/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SWRG
extends ItemPE
implements IPedestalItem,
IProjectileShooter,
ICapabilityAware {
    public SWRG(Item.Properties props) {
        super(props.component(PEDataComponentTypes.SWRG_MODE, (Object)SWRGMode.OFF).component(PEDataComponentTypes.STORED_EMC, (Object)0L).component(PEDataComponentTypes.UNPROCESSED_EMC, (Object)0.0));
    }

    private void tick(ItemStack stack, Player player) {
        float toRemove;
        SWRGMode mode = this.getMode(stack);
        if (mode.hasShield()) {
            WorldHelper.repelEntitiesSWRG(player.level(), player.getBoundingBox().inflate(5.0), player);
        }
        if (player.level().isClientSide) {
            return;
        }
        if (!SWRG.hasEmc(player, stack, 64L, true)) {
            this.changeMode(player, stack, mode, SWRGMode.OFF);
            return;
        }
        if (player.getAbilities().flying) {
            if (!mode.hasFlight()) {
                mode = this.changeMode(player, stack, mode, mode.toggleFlight());
            }
        } else if (mode.hasFlight()) {
            mode = this.changeMode(player, stack, mode, mode.toggleFlight());
        }
        float f = toRemove = mode.hasShield() ? 0.32f : 0.0f;
        if (mode.hasFlight() && player.getAbilities().flying) {
            toRemove += 0.32f;
        }
        SWRG.removeEmc(stack, toRemove);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (SWRG.hotBarOrOffHand(slot) && entity instanceof Player) {
            Player player = (Player)entity;
            this.tick(stack, player);
        }
    }

    private SWRGMode getMode(ItemStack stack) {
        return (SWRGMode)((Object)stack.getOrDefault(PEDataComponentTypes.SWRG_MODE, (Object)SWRGMode.OFF));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            SWRGMode oldMode = this.getMode(stack);
            this.changeMode(player, stack, oldMode, oldMode.next());
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private SWRGMode changeMode(Player player, ItemStack stack, SWRGMode oldMode, SWRGMode mode) {
        if (mode == oldMode) {
            return mode;
        }
        stack.set(PEDataComponentTypes.SWRG_MODE, (Object)mode);
        if (player == null) {
            return mode;
        }
        if (mode == SWRGMode.OFF || oldMode == SWRGMode.SHIELDED_FLIGHT) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        } else if (oldMode == SWRGMode.OFF || mode == SWRGMode.SHIELDED_FLIGHT) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        }
        return mode;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() <= 0) {
                for (Mob living : level.getEntitiesOfClass(Mob.class, ((IDMPedestal)pedestal).getEffectBounds(), ent -> {
                    TamableAnimal tamableAnimal;
                    return !ent.isSpectator() && (!(ent instanceof TamableAnimal) || !(tamableAnimal = (TamableAnimal)ent).isTame());
                })) {
                    LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                    if (lightning == null) continue;
                    lightning.moveTo(living.position());
                    level.addFreshEntity((Entity)lightning);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.swrg.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            list.add((Component)PELang.PEDESTAL_SWRG_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_SWRG_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.swrg.get(), tickRate)));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, @Nullable InteractionHand hand) {
        EntitySWRGProjectile projectile = new EntitySWRGProjectile(player, false, player.level());
        projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        player.level().addFreshEntity((Entity)projectile);
        return true;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    public static enum SWRGMode implements StringRepresentable
    {
        OFF,
        FLIGHT,
        SHIELD,
        SHIELDED_FLIGHT;

        public static final Codec<SWRGMode> CODEC;
        public static final IntFunction<SWRGMode> BY_ID;
        public static final StreamCodec<ByteBuf, SWRGMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        public boolean hasFlight() {
            return this == FLIGHT || this == SHIELDED_FLIGHT;
        }

        public boolean hasShield() {
            return this == SHIELD || this == SHIELDED_FLIGHT;
        }

        public SWRGMode toggleFlight() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FLIGHT;
                case 2 -> SHIELDED_FLIGHT;
                case 1 -> OFF;
                case 3 -> SHIELD;
            };
        }

        public SWRGMode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SHIELD;
                case 2 -> OFF;
                case 1 -> SHIELDED_FLIGHT;
                case 3 -> FLIGHT;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(SWRGMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])SWRGMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

