/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.RegistryUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class TimeWatch
extends PEToggleItem
implements IPedestalItem,
IItemCharge,
IBarHelper {
    private static final Predicate<BlockEntity> VALID_TARGET = be -> !be.isRemoved() && be.hasLevel() && !RegistryUtils.getBEHolder(be.getType()).is(PETags.BlockEntities.BLACKLIST_TIME_WATCH);

    public TimeWatch(Item.Properties props) {
        super(props.component(PEDataComponentTypes.CHARGE, (Object)0).component(PEDataComponentTypes.STORED_EMC, (Object)0L).component(PEDataComponentTypes.UNPROCESSED_EMC, (Object)0.0));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (!ProjectEConfig.server.items.enableTimeWatch.get()) {
                player.sendSystemMessage((Component)PELang.TIME_WATCH_DISABLED.translate());
                return InteractionResultHolder.fail((Object)stack);
            }
            stack.update(PEDataComponentTypes.TIME_WATCH_MODE, (Object)TimeWatchMode.OFF, TimeWatchMode::next);
            player.sendSystemMessage((Component)PELang.TIME_WATCH_MODE_SWITCH.translate(this.getTimeName(stack)));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        float mobSlowdown;
        int bonusTicks;
        Player player;
        block15: {
            block14: {
                super.inventoryTick(stack, level, entity, slot, isHeld);
                if (!(entity instanceof Player)) break block14;
                player = (Player)entity;
                if (TimeWatch.hotBarOrOffHand(slot) && ProjectEConfig.server.items.enableTimeWatch.get()) break block15;
            }
            return;
        }
        TimeWatchMode timeControl = (TimeWatchMode)((Object)stack.getOrDefault(PEDataComponentTypes.TIME_WATCH_MODE, (Object)TimeWatchMode.OFF));
        if (timeControl != TimeWatchMode.OFF && !level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            ServerLevel serverWorld = (ServerLevel)level;
            long scaledCharge = 4L * (long)(this.getCharge(stack) + 1);
            if (timeControl == TimeWatchMode.REWIND) {
                serverWorld.setDayTime(Math.max(level.getDayTime() - scaledCharge, 0L));
            } else if (level.getDayTime() > Long.MAX_VALUE - scaledCharge) {
                serverWorld.setDayTime(Long.MAX_VALUE);
            } else {
                serverWorld.setDayTime(level.getDayTime() + scaledCharge);
            }
        }
        if (level.isClientSide || !((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            return;
        }
        int charge = this.getCharge(stack);
        long reqEmc = EMCHelper.removeFractionalEMC(stack, this.getEmcPerTick(charge));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AABB effectBounds = player.getBoundingBox().inflate(8.0);
        this.speedUpBlocks(level, bonusTicks, effectBounds);
        this.slowMobs(level, effectBounds, mobSlowdown);
    }

    private void slowMobs(Level level, AABB effectBounds, double mobSlowdown) {
        if (mobSlowdown < 1.0) {
            for (Mob ent : level.getEntitiesOfClass(Mob.class, effectBounds)) {
                ent.setDeltaMovement(ent.getDeltaMovement().multiply(mobSlowdown, 1.0, mobSlowdown));
            }
        }
    }

    private void speedUpBlocks(Level level, int bonusTicks, AABB effectBounds) {
        if (bonusTicks > 0) {
            this.speedUpBlockEntities(level, bonusTicks, effectBounds);
            this.speedUpRandomTicks(level, bonusTicks, effectBounds);
        }
    }

    private void speedUpBlockEntities(Level level, int bonusTicks, AABB effectBounds) {
        for (BlockEntity blockEntity : WorldHelper.getBlockEntitiesWithinAABB(level, effectBounds, VALID_TARGET)) {
            BlockPos pos = blockEntity.getBlockPos();
            if (!level.shouldTickBlocksAt(ChunkPos.asLong((BlockPos)pos))) continue;
            LevelChunk chunk = level.getChunkAt(pos);
            LevelChunk.RebindableTickingBlockEntityWrapper tickingWrapper = (LevelChunk.RebindableTickingBlockEntityWrapper)chunk.tickersInLevel.get(pos);
            if (tickingWrapper == null || tickingWrapper.isRemoved()) continue;
            TickingBlockEntity tickingBlockEntity = tickingWrapper.ticker;
            if (tickingBlockEntity instanceof LevelChunk.BoundTickingBlockEntity) {
                LevelChunk.BoundTickingBlockEntity tickingBE = (LevelChunk.BoundTickingBlockEntity)tickingBlockEntity;
                if (!chunk.isTicking(pos)) continue;
                ProfilerFiller profiler = level.getProfiler();
                profiler.push(() -> ((LevelChunk.RebindableTickingBlockEntityWrapper)tickingWrapper).getType());
                BlockState state = chunk.getBlockState(pos);
                this.provideBonusTicks(level, pos, state, blockEntity, tickingBE, bonusTicks);
                profiler.pop();
                continue;
            }
            for (int i = 0; i < bonusTicks; ++i) {
                tickingWrapper.tick();
            }
        }
    }

    private <T extends BlockEntity> void provideBonusTicks(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, LevelChunk.BoundTickingBlockEntity<T> tickingBE, int bonusTicks) {
        if (blockEntity.getType().isValid(state)) {
            BlockEntity be = blockEntity;
            for (int i = 0; i < bonusTicks; ++i) {
                tickingBE.ticker.tick(level, pos, state, be);
            }
        }
    }

    private void speedUpRandomTicks(Level level, int bonusTicks, AABB effectBounds) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (BlockPos pos : WorldHelper.getPositionsInBox(effectBounds)) {
            FluidState fluidState;
            BlockState state;
            if (!WorldHelper.isBlockLoaded((BlockGetter)level, pos) || !(state = level.getBlockState(pos)).isRandomlyTicking() || state.is(PETags.Blocks.BLACKLIST_TIME_WATCH) || !(fluidState = state.getFluidState()).isEmpty() && !fluidState.isSource() || WorldHelper.isCrop(state)) continue;
            pos = pos.immutable();
            for (int i = 0; i < bonusTicks; ++i) {
                state.randomTick(serverLevel, pos, level.random);
            }
        }
    }

    private ILangEntry getTimeName(ItemStack stack) {
        return ((TimeWatchMode)((Object)stack.getOrDefault(PEDataComponentTypes.TIME_WATCH_MODE, (Object)((Object)TimeWatchMode.OFF)))).name;
    }

    public double getEmcPerTick(int charge) {
        return (double)(charge + 2) / 2.0;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)PELang.TOOLTIP_TIME_WATCH_1.translate());
        tooltip.add((Component)PELang.TOOLTIP_TIME_WATCH_2.translate(Component.keybind((String)"key.use")));
        tooltip.add((Component)PELang.TIME_WATCH_MODE.translate(this.getTimeName(stack)));
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.items.enableTimeWatch.get()) {
            AABB effectBounds = ((IDMPedestal)pedestal).getEffectBounds();
            this.speedUpBlocks(level, ProjectEConfig.server.effects.timePedBonus.get(), effectBounds);
            this.slowMobs(level, effectBounds, ProjectEConfig.server.effects.timePedMobSlowness.get());
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.effects.timePedBonus.get() > 0) {
            list.add((Component)PELang.PEDESTAL_TIME_WATCH_1.translateColored(ChatFormatting.BLUE, ProjectEConfig.server.effects.timePedBonus.get()));
        }
        if (ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
            list.add((Component)PELang.PEDESTAL_TIME_WATCH_2.translateColored(ChatFormatting.BLUE, String.format("%.3f", ProjectEConfig.server.effects.timePedMobSlowness.get())));
        }
        return list;
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public static enum TimeWatchMode implements StringRepresentable
    {
        OFF(PELang.TIME_WATCH_OFF),
        FAST_FORWARD(PELang.TIME_WATCH_FAST_FORWARD),
        REWIND(PELang.TIME_WATCH_REWIND);

        public static final Codec<TimeWatchMode> CODEC;
        public static final IntFunction<TimeWatchMode> BY_ID;
        public static final StreamCodec<ByteBuf, TimeWatchMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry name;

        private TimeWatchMode(ILangEntry name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        public TimeWatchMode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FAST_FORWARD;
                case 1 -> REWIND;
                case 2 -> OFF;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(TimeWatchMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TimeWatchMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

