/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registration.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import moze_intel.projecte.gameObjs.registration.PEDeferredRegister;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTypeDeferredRegister
extends PEDeferredRegister<BlockEntityType<?>> {
    public BlockEntityTypeDeferredRegister(String modid) {
        super(Registries.BLOCK_ENTITY_TYPE, modid, BlockEntityTypeRegistryObject::new);
    }

    public <BE extends BlockEntity> BlockEntityTypeBuilder<BE> builder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return new BlockEntityTypeBuilder<BE>(block, factory);
    }

    private <BE extends BlockEntity> BlockEntityTypeRegistryObject<BE> registerPE(String name, Supplier<? extends BlockEntityType<BE>> sup) {
        return (BlockEntityTypeRegistryObject)super.register(name, sup);
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(this::registerCapabilities);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder entry : this.getEntries()) {
            if (entry instanceof BlockEntityTypeRegistryObject) {
                BlockEntityTypeRegistryObject beRO = (BlockEntityTypeRegistryObject)entry;
                beRO.registerCapabilityProviders(event);
                continue;
            }
            if (FMLEnvironment.production) continue;
            throw new IllegalStateException("Expected entry to be a BlockEntityTypeRegistryObject");
        }
    }

    public class BlockEntityTypeBuilder<BE extends BlockEntity> {
        private static final ICapabilityProvider<?, ?, ?> SIMPLE_PROVIDER = (obj, context) -> obj;
        private final BlockRegistryObject<?, ?> block;
        private final BlockEntityType.BlockEntitySupplier<? extends BE> factory;
        private final List<BlockEntityTypeRegistryObject.CapabilityData<BE, ?, ?>> capabilityProviders = new ArrayList();
        @Nullable
        private BlockEntityTicker<BE> clientTicker;
        @Nullable
        private BlockEntityTicker<BE> serverTicker;

        BlockEntityTypeBuilder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
            this.block = block;
            this.factory = factory;
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> withSimple(BlockCapability<CAP, CONTEXT> capability) {
            return this.withSimple(capability, () -> true);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> withSimple(BlockCapability<CAP, CONTEXT> capability, BooleanSupplier shouldApply) {
            return this.with(capability, SIMPLE_PROVIDER, shouldApply);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, Function<BlockCapability<CAP, CONTEXT>, ICapabilityProvider<? super BE, CONTEXT, CAP>> provider) {
            return this.with(capability, provider.apply(capability));
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, ICapabilityProvider<? super BE, CONTEXT, CAP> provider) {
            return this.with(capability, provider, () -> true);
        }

        public <CAP, CONTEXT> BlockEntityTypeBuilder<BE> with(BlockCapability<CAP, CONTEXT> capability, ICapabilityProvider<? super BE, CONTEXT, CAP> provider, BooleanSupplier shouldApply) {
            this.capabilityProviders.add(new BlockEntityTypeRegistryObject.CapabilityData<BE, CAP, CONTEXT>(capability, provider, shouldApply));
            return this;
        }

        public BlockEntityTypeBuilder<BE> without(BlockCapability<?, ?> ... capabilities) {
            for (BlockCapability<?, ?> capability : capabilities) {
                this.capabilityProviders.removeIf(data -> data.capability() == capability);
            }
            return this;
        }

        public BlockEntityTypeBuilder<BE> without(Collection<? extends BlockCapability<?, ?>> capabilities) {
            this.capabilityProviders.removeIf(data -> capabilities.contains(data.capability()));
            return this;
        }

        public BlockEntityTypeBuilder<BE> clientTicker(BlockEntityTicker<BE> ticker) {
            Preconditions.checkState((this.clientTicker == null ? 1 : 0) != 0, (Object)"Client ticker may only be set once.");
            this.clientTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> serverTicker(BlockEntityTicker<BE> ticker) {
            Preconditions.checkState((this.serverTicker == null ? 1 : 0) != 0, (Object)"Server ticker may only be set once.");
            this.serverTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> commonTicker(BlockEntityTicker<BE> ticker) {
            return this.clientTicker(ticker).serverTicker(ticker);
        }

        public BlockEntityTypeRegistryObject<BE> build() {
            BlockEntityTypeRegistryObject<BE> holder = BlockEntityTypeDeferredRegister.this.registerPE(this.block.getName(), () -> BlockEntityType.Builder.of(this.factory, (Block[])this.block.getBlocks()).build(null));
            holder.tickers(this.clientTicker, this.serverTicker);
            holder.capabilities(this.capabilityProviders.isEmpty() ? null : this.capabilityProviders);
            return holder;
        }
    }
}

