/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registration.impl;

import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.gameObjs.registration.DoubleWrappedRegistryObject;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BlockRegistryObject<BLOCK extends Block, ITEM extends Item>
extends DoubleWrappedRegistryObject<Block, BLOCK, Item, ITEM>
implements ItemLike,
IHasTranslationKey {
    public BlockRegistryObject(DeferredHolder<Block, BLOCK> blockRegistryObject, DeferredHolder<Item, ITEM> itemRegistryObject) {
        super(blockRegistryObject, itemRegistryObject);
    }

    @NotNull
    public BLOCK getBlock() {
        return (BLOCK)((Block)this.getPrimary());
    }

    @NotNull
    public BlockState defaultState() {
        return this.getBlock().defaultBlockState();
    }

    @NotNull
    public ITEM asItem() {
        return (ITEM)((Item)this.getSecondary());
    }

    @Override
    public String getTranslationKey() {
        return this.getBlock().getDescriptionId();
    }

    @ApiStatus.Internal
    Block[] getBlocks() {
        return new Block[]{this.getBlock()};
    }

    public static class WallOrFloorBlockRegistryObject<BLOCK extends Block, WALL_BLOCK extends Block, ITEM extends StandingAndWallBlockItem>
    extends BlockRegistryObject<BLOCK, ITEM> {
        @NotNull
        private final DeferredHolder<Block, WALL_BLOCK> wallRO;

        public WallOrFloorBlockRegistryObject(DeferredHolder<Block, BLOCK> blockRegistryObject, DeferredHolder<Block, WALL_BLOCK> wallBlockRegistryObject, DeferredHolder<Item, ITEM> itemRegistryObject) {
            super(blockRegistryObject, itemRegistryObject);
            this.wallRO = wallBlockRegistryObject;
        }

        @NotNull
        public WALL_BLOCK getWallBlock() {
            return (WALL_BLOCK)((Block)this.wallRO.get());
        }

        public String getWallName() {
            return this.wallRO.getId().getPath();
        }

        @Override
        @ApiStatus.Internal
        Block[] getBlocks() {
            return new Block[]{this.getBlock(), this.getWallBlock()};
        }
    }
}

