/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.core.Holder;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;

public class InternalAbilities {
    private static final AttributeModifier FLIGHT = new AttributeModifier(PECore.rl("flight"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier WATER_SPEED_BOOST = new AttributeModifier(PECore.rl("water_speed_boost"), 0.15, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier LAVA_SPEED_BOOST = new AttributeModifier(PECore.rl("lava_speed_boost"), 0.15, AttributeModifier.Operation.ADD_VALUE);

    public static void tick(Player player) {
        Object applyWaterSpeed = Predicates.alwaysFalse();
        Object applyLavaSpeed = Predicates.alwaysFalse();
        WalkOnType waterWalkOnType = InternalAbilities.canWalkOnWater(player);
        WalkOnType lavaWalkOnType = InternalAbilities.canWalkOnLava(player);
        if (waterWalkOnType.canWalk() || lavaWalkOnType.canWalk()) {
            boolean lava;
            FluidState below = player.level().getFluidState(player.getOnPos());
            boolean water = waterWalkOnType.canWalk() && below.is(FluidTags.WATER);
            boolean bl = lava = lavaWalkOnType.canWalk() && below.is(FluidTags.LAVA);
            if ((water || lava) && player.getInBlockState().isAir()) {
                if (!player.isShiftKeyDown()) {
                    player.setDeltaMovement(player.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                    player.resetFallDistance();
                    player.setOnGround(true);
                }
                applyWaterSpeed = waterWalkOnType.applySpeed(water);
                applyLavaSpeed = lavaWalkOnType.applySpeed(lava);
            } else if (!player.level().isClientSide && waterWalkOnType.canWalk() && player.isInWater()) {
                player.setAirSupply(player.getMaxAirSupply());
            }
        }
        if (!player.level().isClientSide) {
            InternalAbilities.updateAttribute(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, WATER_SPEED_BOOST, (Predicate<Player>)applyWaterSpeed);
            InternalAbilities.updateAttribute(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, LAVA_SPEED_BOOST, (Predicate<Player>)applyLavaSpeed);
            InternalAbilities.updateAttribute(player, (Holder<Attribute>)NeoForgeMod.CREATIVE_FLIGHT, FLIGHT, InternalAbilities::shouldPlayerFly);
        }
    }

    private static void updateAttribute(Player player, Holder<Attribute> attribute, AttributeModifier modifier, Predicate<Player> applyAttribute) {
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        if (attributeInstance != null) {
            boolean hasModifier = attributeInstance.hasModifier(modifier.id());
            if (applyAttribute.test(player)) {
                if (!hasModifier) {
                    attributeInstance.addTransientModifier(modifier);
                }
            } else if (hasModifier) {
                attributeInstance.removeModifier(modifier.id());
            }
        }
    }

    private static boolean shouldPlayerFly(Player player) {
        return PlayerHelper.checkHotbarCurios(player, (p, stack) -> stack.is(PEItems.SWIFTWOLF_RENDING_GALE) && ItemPE.hasEmc(p, stack, 64L, true)) || PlayerHelper.checkHotbar(player, (p, stack) -> stack.is(PEItems.ARCANA_RING));
    }

    private static WalkOnType canWalkOnWater(Player player) {
        if (PlayerHelper.checkHotbarCurios(player, (p, stack) -> stack.is(PEItems.EVERTIDE_AMULET))) {
            return WalkOnType.ABLE_WITH_SPEED;
        }
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        return !helmet.isEmpty() && helmet.is(PEItems.GEM_HELMET) ? WalkOnType.ABLE : WalkOnType.UNABLE;
    }

    private static WalkOnType canWalkOnLava(Player player) {
        if (PlayerHelper.checkHotbarCurios(player, (p, stack) -> stack.is(PEItems.VOLCANITE_AMULET))) {
            return WalkOnType.ABLE_WITH_SPEED;
        }
        ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
        return !chestplate.isEmpty() && chestplate.is(PEItems.GEM_CHESTPLATE) ? WalkOnType.ABLE : WalkOnType.UNABLE;
    }

    private static enum WalkOnType {
        ABLE,
        ABLE_WITH_SPEED,
        UNABLE;


        public boolean canWalk() {
            return this != UNABLE;
        }

        public Predicate<Player> applySpeed(boolean onType) {
            if (onType && this == ABLE_WITH_SPEED) {
                return Predicates.alwaysTrue();
            }
            return Predicates.alwaysFalse();
        }
    }
}

