/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.codec;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectERegistries;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.codec.MapProcessor;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.impl.codec.PEUnboundedMapCodec;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PECodecHelper
implements IPECodecHelper {
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final MethodHandle HANDLER_STACK_FIELD = (MethodHandle)Util.make(() -> {
        try {
            Field field = ItemStackHandler.class.getDeclaredField("stacks");
            field.setAccessible(true);
            return MethodHandles.lookup().unreflectGetter(field);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException("Couldn't get getter MethodHandle for stacks", roe);
        }
    });
    private static final Codec<ItemStack> LENIENT_STACK_CODEC = ItemStack.CODEC.promotePartial(error -> PECore.LOGGER.error("Tried to load invalid item: '{}'", error));
    private static final Codec<ItemStack> LENIENT_OPTIONAL_STACK_CODEC = ExtraCodecs.optionalEmptyMap((Codec)LENIENT_STACK_CODEC.orElse((Object)ItemStack.EMPTY)).xmap(stack -> stack.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStackHandler> MUTABLE_HANDLER_CODEC = LENIENT_OPTIONAL_STACK_CODEC.listOf().flatComapMap(list -> {
        NonNullList itemList = NonNullList.createWithCapacity((int)list.size());
        itemList.addAll((Collection)list);
        return new ItemStackHandler(itemList);
    }, handler -> {
        try {
            return DataResult.success((Object)HANDLER_STACK_FIELD.invokeExact((ItemStackHandler)handler));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    });
    private final Codec<Long> NON_NEGATIVE_LONG = this.longRangeWithMessage(0L, Long.MAX_VALUE, value -> "Value must be non-negative: " + value);
    private final Codec<Long> POSITIVE_LONG = this.longRangeWithMessage(1L, Long.MAX_VALUE, value -> "Value must be positive: " + value);
    private final Codec<BigInteger> BIG_INT = Codec.STRING.xmap(val -> val.isEmpty() ? BigInteger.ZERO : new BigInteger((String)val), BigInteger::toString);
    private final Codec<BigInteger> NON_NEGATIVE_BIG_INT = this.bigIntRangeWithMessage(BigInteger.ZERO, null, value -> "Value must be non-negative: " + String.valueOf(value));
    private final Codec<BigInteger> POSITIVE_BIG_INT = this.bigIntRangeWithMessage(BigInteger.ONE, null, value -> "Value must be non-negative: " + String.valueOf(value));
    private final MapCodec<NormalizedSimpleStack> NSS_MAP_CODEC = ProjectERegistries.NSS_SERIALIZER.byNameCodec().dispatchMap(NormalizedSimpleStack::codec, Function.identity());
    private final Codec<NormalizedSimpleStack> NSS_CODEC = this.NSS_MAP_CODEC.codec();

    @Override
    public Codec<NormalizedSimpleStack> nssCodec() {
        return this.NSS_CODEC;
    }

    @Override
    public MapCodec<NormalizedSimpleStack> nssMapCodec() {
        return this.NSS_MAP_CODEC;
    }

    @Override
    public Codec<Long> nonNegativeLong() {
        return this.NON_NEGATIVE_LONG;
    }

    @Override
    public Codec<Long> positiveLong() {
        return this.POSITIVE_LONG;
    }

    @Override
    public Codec<Long> longRangeWithMessage(long min, long max, Function<Long, String> errorMessage) {
        return Codec.LONG.validate(value -> value.compareTo(min) >= 0 && value.compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> (String)errorMessage.apply((Long)value)));
    }

    @Override
    public Codec<BigInteger> nonNegativeBigInt() {
        return this.NON_NEGATIVE_BIG_INT;
    }

    @Override
    public Codec<BigInteger> positiveBigInt() {
        return this.POSITIVE_BIG_INT;
    }

    @Override
    public Codec<BigInteger> bigIntRangeWithMessage(@Nullable BigInteger min, @Nullable BigInteger max, Function<BigInteger, String> errorMessage) {
        if (min == null && max == null) {
            return this.BIG_INT;
        }
        return this.BIG_INT.validate(value -> {
            if (!(min != null && value.compareTo(min) < 0 || max != null && value.compareTo(max) > 0)) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)errorMessage.apply((BigInteger)value));
        });
    }

    @Override
    public <K, V> Codec<Map<K, V>> lenientKeyUnboundedMap(MapCodec<K> keyCodec, MapCodec<V> elementCodec, MapProcessor<K, V> processor) {
        return PEUnboundedMapCodec.create(keyCodec, elementCodec, processor, true);
    }

    @Override
    public <K, V> Codec<Map<K, V>> unboundedMap(MapCodec<K> keyCodec, MapCodec<V> elementCodec, MapProcessor<K, V> processor) {
        return PEUnboundedMapCodec.create(keyCodec, elementCodec, processor, false);
    }

    public <TYPE> MapCodec<TYPE> orElseWithLog(MapCodec<TYPE> codec, final TYPE fallback, final Supplier<String> onError) {
        return codec.mapResult(new MapCodec.ResultFunction<TYPE>(this){

            public <T> DataResult<TYPE> apply(DynamicOps<T> ops, MapLike<T> input, DataResult<TYPE> result) {
                if (result.isError()) {
                    PECore.LOGGER.error((String)onError.get(), (Object)((DataResult.Error)result.error().orElseThrow()).message());
                    return DataResult.success((Object)fallback);
                }
                return result;
            }

            public <T> RecordBuilder<T> coApply(DynamicOps<T> ops, TYPE input, RecordBuilder<T> builder) {
                return builder;
            }

            public String toString() {
                return "projecte:OrElseWithLog[" + String.valueOf(onError) + " " + String.valueOf(fallback) + "]";
            }
        });
    }

    public static <TYPE> void writeToFile(HolderLookup.Provider registries, Path path, Codec<TYPE> codec, TYPE value, String fileDescription) {
        DataResult result = codec.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), value);
        if (result.isError()) {
            PECore.LOGGER.error("Failed to convert {} to json: {}", (Object)fileDescription, (Object)((DataResult.Error)result.error().orElseThrow()).message());
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            PRETTY_GSON.toJson((JsonElement)result.getOrThrow(), (Appendable)writer);
        }
        catch (IOException e) {
            PECore.LOGGER.error("Failed to write {} file: {}", new Object[]{fileDescription, path, e});
        }
    }

    public static <TYPE> Optional<TYPE> readFromFile(HolderLookup.Provider registries, Path path, Codec<TYPE> codec, String fileDescription) {
        if (Files.exists(path, new LinkOption[0])) {
            Optional<TYPE> optional;
            block9: {
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    optional = PECodecHelper.read(registries, (Reader)reader, codec, fileDescription);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        PECore.LOGGER.error("Couldn't access {} file: {}", new Object[]{fileDescription, path, e});
                    }
                }
                reader.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public static <TYPE> Optional<TYPE> read(HolderLookup.Provider registryAccess, Reader reader, Codec<TYPE> codec, String description) {
        return PECodecHelper.read((DynamicOps<JsonElement>)registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE), reader, codec, description);
    }

    public static <TYPE> Optional<TYPE> read(DynamicOps<JsonElement> ops, Reader reader, Codec<TYPE> codec, String description) {
        JsonElement json;
        try {
            json = JsonParser.parseReader((Reader)reader);
        }
        catch (JsonParseException e) {
            PECore.LOGGER.error("Couldn't parse {}", (Object)description, (Object)e);
            return Optional.empty();
        }
        DataResult result = codec.parse(ops, (Object)json);
        if (result.isError()) {
            PECore.LOGGER.error("Couldn't parse {}: {}", (Object)description, (Object)((DataResult.Error)result.error().orElseThrow()).message());
            return Optional.empty();
        }
        return result.result();
    }
}

