/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.integration.crafttweaker.actions.CustomConversionAction;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/ProjectE/CustomConversion")
@ZenCodeType.Name(value="mods.projecte.CustomConversion")
public class CrTCustomConversion {
    private CrTCustomConversion() {
    }

    @ZenCodeType.Method
    public static void addConversion(NormalizedSimpleStack stack, int amount, Map<NormalizedSimpleStack, Integer> ingredients) {
        CrTCustomConversion.addConversion(stack, amount, stack instanceof NSSTag, ingredients);
    }

    @ZenCodeType.Method
    public static void addConversion(NormalizedSimpleStack stack, int amount, boolean propagateTags, Map<NormalizedSimpleStack, Integer> ingredients) {
        if (propagateTags && !(stack instanceof NSSTag)) {
            throw new IllegalArgumentException("Propagate Tags should always be false if the output is not a tag.");
        }
        CraftTweakerAPI.apply((IAction)new CustomConversionAction(stack, amount, propagateTags, false, ingredients));
    }

    @ZenCodeType.Method
    public static void addConversion(NormalizedSimpleStack stack, int amount, NormalizedSimpleStack ... ingredients) {
        CrTCustomConversion.addConversion(stack, amount, stack instanceof NSSTag, ingredients);
    }

    @ZenCodeType.Method
    public static void addConversion(NormalizedSimpleStack stack, int amount, boolean propagateTags, NormalizedSimpleStack ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("No ingredients specified for conversion.");
        }
        CrTCustomConversion.addConversion(stack, amount, propagateTags, Arrays.stream(ingredients).collect(Collectors.toMap(Function.identity(), ingredient -> 1, Integer::sum)));
    }

    @ZenCodeType.Method
    public static void setConversion(NormalizedSimpleStack stack, int amount, Map<NormalizedSimpleStack, Integer> ingredients) {
        CrTCustomConversion.setConversion(stack, amount, stack instanceof NSSTag, ingredients);
    }

    @ZenCodeType.Method
    public static void setConversion(NormalizedSimpleStack stack, int amount, boolean propagateTags, Map<NormalizedSimpleStack, Integer> ingredients) {
        if (propagateTags && !(stack instanceof NSSTag)) {
            throw new IllegalArgumentException("Propagate Tags should always be false if the output is not a tag.");
        }
        CraftTweakerAPI.apply((IAction)new CustomConversionAction(stack, amount, propagateTags, true, ingredients));
    }

    @ZenCodeType.Method
    public static void setConversion(NormalizedSimpleStack stack, int amount, NormalizedSimpleStack ... ingredients) {
        CrTCustomConversion.setConversion(stack, amount, stack instanceof NSSTag, ingredients);
    }

    @ZenCodeType.Method
    public static void setConversion(NormalizedSimpleStack stack, int amount, boolean propagateTags, NormalizedSimpleStack ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("No ingredients specified for conversion.");
        }
        CrTCustomConversion.setConversion(stack, amount, propagateTags, Arrays.stream(ingredients).collect(Collectors.toMap(Function.identity(), ingredient -> 1, Integer::sum)));
    }
}

