/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.mappers;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

@EMCMapper(requiredMods={"crafttweaker"})
public class CrTCustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final Object2LongMap<NormalizedSimpleStack> customEmcValues = new Object2LongOpenHashMap();

    public static void registerCustomEMC(@NotNull NormalizedSimpleStack stack, long emcValue) {
        customEmcValues.put((Object)stack, emcValue);
    }

    public static void unregisterNSS(@NotNull NormalizedSimpleStack stack) {
        customEmcValues.removeLong((Object)stack);
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        ObjectIterator iterator = Object2LongMaps.fastIterator(customEmcValues);
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            NormalizedSimpleStack normStack = (NormalizedSimpleStack)entry.getKey();
            long value = entry.getLongValue();
            normStack.forSelfAndEachElement(mapper, value, IMappingCollector::setValueBefore);
            PECore.debugLog("CraftTweaker setting value for {} to {}", normStack, value);
        }
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_CRT_EMC_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_CRT_EMC_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_CRT_EMC_MAPPER.tooltip();
    }
}

