/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutation;
import moze_intel.projecte.integration.recipe_viewer.RecipeViewerHelper;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record WorldTransmuteEntry(Either<ItemStack, FluidStack> input, Either<ItemStack, FluidStack> output, @Nullable Either<ItemStack, FluidStack> altOutput) {
    private static final Codec<Either<ItemStack, FluidStack>> EITHER_CODEC = Codec.either((Codec)ItemStack.SINGLE_ITEM_CODEC, (Codec)FluidStack.fixedAmountCodec((int)1000));
    public static final Codec<WorldTransmuteEntry> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EITHER_CODEC.fieldOf("input").forGetter(WorldTransmuteEntry::input), (App)EITHER_CODEC.fieldOf("output").forGetter(WorldTransmuteEntry::output), (App)EITHER_CODEC.optionalFieldOf("alt_output").forGetter(entry -> Optional.ofNullable(entry.altOutput()))).apply((Applicative)instance, (input, output, altOutput) -> new WorldTransmuteEntry((Either<ItemStack, FluidStack>)input, (Either<ItemStack, FluidStack>)output, (Either<ItemStack, FluidStack>)((Either)altOutput.orElse(null)))));

    public ResourceLocation syntheticId() {
        String name = this.stripForSynthetic(this.input) + "/" + this.stripForSynthetic(this.output);
        if (this.altOutput != null) {
            name = name + "/" + this.stripForSynthetic(this.altOutput);
        }
        return PECore.rl("/world_transmutation/" + name + "/");
    }

    private String stripForSynthetic(Either<ItemStack, FluidStack> either) {
        return RecipeViewerHelper.stripForSynthetic((Holder)either.map(ItemStack::getItemHolder, FluidStack::getFluidHolder));
    }

    private static boolean equals(@Nullable Either<ItemStack, FluidStack> a, @Nullable Either<ItemStack, FluidStack> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Optional leftA = a.left();
        Optional leftB = b.left();
        if (leftA.isPresent() != leftB.isPresent()) {
            return false;
        }
        if (leftA.isPresent()) {
            return ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)leftA.get()), (ItemStack)((ItemStack)leftB.get()));
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)a.right().orElse(FluidStack.EMPTY), (FluidStack)b.right().orElse(FluidStack.EMPTY));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldTransmuteEntry other = (WorldTransmuteEntry)o;
        return WorldTransmuteEntry.equals(this.input, other.input) && WorldTransmuteEntry.equals(this.output, other.output) && WorldTransmuteEntry.equals(this.altOutput, other.altOutput);
    }

    private static int hash(Either<ItemStack, FluidStack> either) {
        return (Integer)either.map(ItemStack::hashItemAndComponents, FluidStack::hashFluidAndComponents);
    }

    @Override
    public int hashCode() {
        int hash = WorldTransmuteEntry.hash(this.input);
        hash = 31 * hash + WorldTransmuteEntry.hash(this.output);
        if (this.altOutput != null) {
            hash = 31 * hash + WorldTransmuteEntry.hash(this.altOutput);
        }
        return hash;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static WorldTransmuteEntry create(IWorldTransmutation transmutation) {
        Either<ItemStack, FluidStack> altOutput;
        Either<ItemStack, FluidStack> output;
        Either<ItemStack, FluidStack> input;
        if (transmutation instanceof SimpleWorldTransmutation) {
            Holder<Block> altResult;
            Holder<Block> result;
            Holder<Block> origin;
            SimpleWorldTransmutation simpleWorldTransmutation = (SimpleWorldTransmutation)transmutation;
            try {
                Holder<Block> holder;
                origin = holder = simpleWorldTransmutation.origin();
                result = holder = simpleWorldTransmutation.result();
                altResult = holder = simpleWorldTransmutation.altResult();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            input = WorldTransmuteEntry.createInfo((Block)origin.value());
            output = WorldTransmuteEntry.createInfo((Block)result.value());
            altOutput = transmutation.hasAlternate() ? WorldTransmuteEntry.createInfo((Block)altResult.value()) : null;
        } else {
            BlockState altResult;
            BlockState result;
            BlockState originState;
            if (!(transmutation instanceof WorldTransmutation)) throw new IllegalStateException("Unknown transmutation implementation: " + String.valueOf(transmutation));
            WorldTransmutation worldTransmutation = (WorldTransmutation)transmutation;
            {
                BlockState blockState;
                originState = blockState = worldTransmutation.originState();
                result = blockState = worldTransmutation.result();
                altResult = blockState = worldTransmutation.altResult();
            }
            input = WorldTransmuteEntry.createInfo(originState);
            output = WorldTransmuteEntry.createInfo(result);
            altOutput = transmutation.hasAlternate() ? WorldTransmuteEntry.createInfo(altResult) : null;
        }
        if (input == null) return null;
        if (output == null) return null;
        WorldTransmuteEntry worldTransmuteEntry = new WorldTransmuteEntry(input, output, altOutput);
        return worldTransmuteEntry;
    }

    @Nullable
    private static <STATE> Either<ItemStack, FluidStack> createInfo(STATE state, Function<STATE, Block> blockGetter, Function<STATE, ItemStack> itemGetter) {
        ItemStack item;
        Block block = blockGetter.apply(state);
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            if (liquidBlock.fluid != Fluids.EMPTY) {
                return Either.right((Object)new FluidStack((Fluid)liquidBlock.fluid, 1000));
            }
        }
        return (item = itemGetter.apply(state)).isEmpty() ? null : Either.left((Object)item);
    }

    @Nullable
    private static Either<ItemStack, FluidStack> createInfo(Block block) {
        return WorldTransmuteEntry.createInfo(block, Function.identity(), ItemStack::new);
    }

    @Nullable
    private static Either<ItemStack, FluidStack> createInfo(BlockState state) {
        return WorldTransmuteEntry.createInfo(state, BlockBehaviour.BlockStateBase::getBlock, WorldTransmuteEntry::itemFromBlock);
    }

    private static ItemStack itemFromBlock(BlockState state) {
        try {
            return state.getCloneItemStack(null, null, null, null);
        }
        catch (Exception e) {
            return new ItemStack((ItemLike)state.getBlock());
        }
    }
}

