/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moze_intel.projecte.rendering.PERenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntitySpriteRenderer<ENTITY extends Entity>
extends EntityRenderer<ENTITY> {
    private final ResourceLocation texture;
    private final RenderType renderType;

    public EntitySpriteRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.texture = texture;
        this.renderType = PERenderType.SPRITE_RENDERER.apply(this.texture);
    }

    protected int getBlockLightLevel(@NotNull ENTITY entity, @NotNull BlockPos pos) {
        return 15;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ENTITY entity) {
        return this.texture;
    }

    public void render(@NotNull ENTITY entity, float entityYaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light) {
        matrix.pushPose();
        matrix.scale(0.5f, 0.5f, 0.5f);
        matrix.mulPose(this.entityRenderDispatcher.cameraOrientation());
        VertexConsumer builder = renderer.getBuffer(this.renderType);
        PoseStack.Pose pose = matrix.last();
        EntitySpriteRenderer.vertex(builder, pose, 0.0f, 0, 0, 1);
        EntitySpriteRenderer.vertex(builder, pose, 1.0f, 0, 1, 1);
        EntitySpriteRenderer.vertex(builder, pose, 1.0f, 1, 1, 0);
        EntitySpriteRenderer.vertex(builder, pose, 0.0f, 1, 0, 0);
        matrix.popPose();
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, int y, int u, int v) {
        consumer.addVertex(pose, x - 0.5f, (float)y, 0.0f).setUv((float)u, (float)v);
    }
}

