/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.rendering.PERenderType;
import moze_intel.projecte.utils.Constants;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutationRenderingOverlay
implements LayeredDraw.Layer {
    private final Minecraft mc = Minecraft.getInstance();
    @Nullable
    private Block transmutationResult;
    private long lastGameTime;

    public TransmutationRenderingOverlay() {
        NeoForge.EVENT_BUS.addListener(this::onOverlay);
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker delta) {
        if (!this.mc.options.hideGui && this.transmutationResult != null) {
            long gameTime;
            Block block = this.transmutationResult;
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)liquidBlock.fluid);
                int color = properties.getTintColor();
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                TextureAtlasSprite sprite = (TextureAtlasSprite)this.mc.getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(properties.getStillTexture());
                graphics.blit(1, 1, 0, 16, 16, sprite, red, green, blue, alpha);
            } else {
                graphics.renderItem(new ItemStack((ItemLike)this.transmutationResult), 1, 1);
            }
            long l = gameTime = this.mc.level == null ? 0L : this.mc.level.getGameTime();
            if (this.lastGameTime != gameTime) {
                this.transmutationResult = null;
                this.lastGameTime = gameTime;
            }
        }
    }

    private void onOverlay(RenderHighlightEvent.Block event) {
        Camera activeRenderInfo = event.getCamera();
        Entity entity = activeRenderInfo.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.level();
        this.lastGameTime = level.getGameTime();
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = player.getOffhandItem();
        }
        if (stack.isEmpty() || !stack.is(PEItems.PHILOSOPHERS_STONE)) {
            this.transmutationResult = null;
            return;
        }
        boolean isSneaking = player.isSecondaryUseActive();
        PhilosophersStone philoStone = (PhilosophersStone)stack.getItem();
        BlockHitResult rtr = philoStone.getHitBlock(level, player, isSneaking);
        if (rtr.getType() == HitResult.Type.BLOCK) {
            int charge = philoStone.getCharge(stack);
            PhilosophersStone.PhilosophersStoneMode mode = (PhilosophersStone.PhilosophersStoneMode)philoStone.getMode(stack);
            Object2ReferenceMap<BlockPos, BlockState> changes = PhilosophersStone.getChanges(level, rtr.getBlockPos(), rtr.getDirection(), player.getDirection(), isSneaking, mode, charge);
            if (changes.isEmpty()) {
                this.transmutationResult = null;
            } else {
                this.transmutationResult = ((BlockState)changes.values().iterator().next()).getBlock();
                Vec3 viewPosition = activeRenderInfo.getPosition();
                float alpha = ProjectEConfig.client.pulsatingOverlay.get() ? this.getPulseProportion() * 0.6f : 0.35f;
                VertexConsumer builder = event.getMultiBufferSource().getBuffer(PERenderType.TRANSMUTATION_OVERLAY);
                PoseStack matrix = event.getPoseStack();
                CollisionContext selectionContext = CollisionContext.of((Entity)player);
                for (BlockPos pos : changes.keySet()) {
                    VoxelShape shape;
                    BlockState state = level.getBlockState(pos);
                    if (state.isAir() || (shape = state.getShape((BlockGetter)level, pos, selectionContext)).isEmpty()) continue;
                    matrix.pushPose();
                    matrix.translate((double)pos.getX() - viewPosition.x, (double)pos.getY() - viewPosition.y, (double)pos.getZ() - viewPosition.z);
                    shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                        for (Direction value : Constants.DIRECTIONS) {
                            LevelRenderer.renderFace((PoseStack)matrix, (VertexConsumer)builder, (Direction)value, (float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        }
                    });
                    matrix.popPose();
                }
            }
        } else {
            this.transmutationResult = null;
        }
    }

    private float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

