/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.api.config.IConfigurableElement;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class AnnotationHelper {
    private static final Type MAPPER_TYPE = Type.getType(EMCMapper.class);
    private static final Type RECIPE_TYPE_MAPPER_TYPE = Type.getType(RecipeTypeMapper.class);
    private static final Type DATA_COMPONENT_PROCESSOR_TYPE = Type.getType(DataComponentProcessor.class);

    public static List<IDataComponentProcessor> getDataComponentProcessors() {
        ModList modList = ModList.get();
        ArrayList<IDataComponentProcessor> dataComponentProcessors = new ArrayList<IDataComponentProcessor>();
        Object2IntOpenHashMap priorities = new Object2IntOpenHashMap();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IDataComponentProcessor processor;
                if (!DATA_COMPONENT_PROCESSOR_TYPE.equals((Object)data.annotationType()) || !AnnotationHelper.checkRequiredMods(data) || (processor = AnnotationHelper.getDataComponentProcessor(data.memberName())) == null) continue;
                int priority = AnnotationHelper.getPriority(data);
                dataComponentProcessors.add(processor);
                priorities.put((Object)processor, priority);
                PECore.debugLog("Found and loaded Data Component Processor: {}, with priority {}", processor.getName(), priority);
            }
        }
        dataComponentProcessors.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)priorities).getInt(arg_0)).reversed());
        return dataComponentProcessors;
    }

    public static List<IRecipeTypeMapper> getRecipeTypeMappers() {
        ModList modList = ModList.get();
        ArrayList<IRecipeTypeMapper> recipeTypeMappers = new ArrayList<IRecipeTypeMapper>();
        Object2IntOpenHashMap priorities = new Object2IntOpenHashMap();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IRecipeTypeMapper mapper;
                if (!RECIPE_TYPE_MAPPER_TYPE.equals((Object)data.annotationType()) || !AnnotationHelper.checkRequiredMods(data) || (mapper = AnnotationHelper.getRecipeTypeMapper(data.memberName())) == null) continue;
                int priority = AnnotationHelper.getPriority(data);
                recipeTypeMappers.add(mapper);
                priorities.put((Object)mapper, priority);
                PECore.debugLog("Found and loaded RecipeType Mapper: {}, with priority {}", mapper.getName(), priority);
            }
        }
        recipeTypeMappers.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)priorities).getInt(arg_0)).reversed());
        return recipeTypeMappers;
    }

    public static List<IEMCMapper<NormalizedSimpleStack, Long>> getEMCMappers() {
        ModList modList = ModList.get();
        ArrayList<IEMCMapper<NormalizedSimpleStack, Long>> emcMappers = new ArrayList<IEMCMapper<NormalizedSimpleStack, Long>>();
        Object2IntOpenHashMap priorities = new Object2IntOpenHashMap();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IEMCMapper<?, ?> mapper;
                if (!MAPPER_TYPE.equals((Object)data.annotationType()) || !AnnotationHelper.checkRequiredMods(data) || (mapper = AnnotationHelper.getEMCMapper(data.memberName())) == null) continue;
                try {
                    IEMCMapper<?, ?> emcMapper = mapper;
                    int priority = AnnotationHelper.getPriority(data);
                    emcMappers.add(emcMapper);
                    priorities.put(emcMapper, priority);
                    PECore.debugLog("Found and loaded EMC mapper: {}, with priority {}", mapper.getName(), priority);
                }
                catch (ClassCastException e) {
                    PECore.LOGGER.error("{}: Is not a mapper for {}, to {}", new Object[]{mapper.getClass(), NormalizedSimpleStack.class, Long.class, e});
                }
            }
        }
        emcMappers.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)priorities).getInt(arg_0)).reversed());
        return emcMappers;
    }

    @Nullable
    private static IEMCMapper<?, ?> getEMCMapper(String className) {
        return AnnotationHelper.createOrGetInstance(className, IEMCMapper.class, EMCMapper.Instance.class, IConfigurableElement::getName);
    }

    @Nullable
    private static IRecipeTypeMapper getRecipeTypeMapper(String className) {
        return AnnotationHelper.createOrGetInstance(className, IRecipeTypeMapper.class, RecipeTypeMapper.Instance.class, IConfigurableElement::getName);
    }

    @Nullable
    private static IDataComponentProcessor getDataComponentProcessor(String className) {
        return AnnotationHelper.createOrGetInstance(className, IDataComponentProcessor.class, DataComponentProcessor.Instance.class, IConfigurableElement::getName);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static <T> T createOrGetInstance(String className, Class<T> baseClass, Class<? extends Annotation> instanceAnnotation, Function<T, String> nameFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean checkRequiredMods(ModFileScanData.AnnotationData data) {
        List requiredMods;
        Map annotationData = data.annotationData();
        if (annotationData.containsKey("requiredMods") && (requiredMods = (List)annotationData.get("requiredMods")).stream().anyMatch(modid -> !ModList.get().isLoaded(modid))) {
            PECore.debugLog("Skipped checking class {}, as its required mods ({}) are not loaded.", data.memberName(), Arrays.toString(requiredMods.toArray()));
            return false;
        }
        return true;
    }

    private static int getPriority(ModFileScanData.AnnotationData data) {
        Map annotationData = data.annotationData();
        if (annotationData.containsKey("priority")) {
            return (Integer)annotationData.get("priority");
        }
        return 0;
    }
}

