/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.InputConstants;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientKeyHelper {
    private static ImmutableBiMap<PEKeybind, KeyMapping> peToMc = ImmutableBiMap.of();

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.HELMET_TOGGLE, KeyModifier.SHIFT, 88);
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.BOOTS_TOGGLE, KeyModifier.NONE, 88);
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.CHARGE, KeyModifier.NONE, 86);
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.EXTRA_FUNCTION, KeyModifier.NONE, 67);
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.FIRE_PROJECTILE, KeyModifier.NONE, 82);
        ClientKeyHelper.addKeyBinding(event, (ImmutableBiMap.Builder<PEKeybind, KeyMapping>)builder, PEKeybind.MODE, KeyModifier.NONE, 71);
        peToMc = builder.build();
    }

    private static void addKeyBinding(RegisterKeyMappingsEvent event, ImmutableBiMap.Builder<PEKeybind, KeyMapping> builder, PEKeybind keyBind, KeyModifier modifier, int keyCode) {
        PEKeyMapping keyMapping = new PEKeyMapping(keyBind, modifier, keyCode);
        builder.put((Object)keyBind, (Object)keyMapping);
        event.register((KeyMapping)keyMapping);
    }

    public static Component getKeyName(PEKeybind k) {
        KeyMapping keyMapping = (KeyMapping)peToMc.get((Object)k);
        if (keyMapping == null) {
            return TextComponentUtil.build(k);
        }
        return keyMapping.getTranslatedKeyMessage();
    }

    private static class PEKeyMapping
    extends KeyMapping {
        private final PEKeybind keybind;
        private boolean lastState;

        PEKeyMapping(PEKeybind keybind, KeyModifier keyModifier, int keyCode) {
            super(keybind.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, keyModifier, InputConstants.Type.KEYSYM, keyCode, PELang.PROJECTE.getTranslationKey());
            this.keybind = keybind;
        }

        public void setDown(boolean value) {
            super.setDown(value);
            boolean state = this.isDown();
            if (state != this.lastState) {
                if (state) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressPKT(this.keybind), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.lastState = state;
            }
        }
    }
}

