/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.math.BigInteger;
import java.text.NumberFormat;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class EMCHelper {
    private static final NumberFormat EMC_FORMATTER = (NumberFormat)Util.make((Object)NumberFormat.getInstance(), formatter -> formatter.setMaximumFractionDigits(1));

    public static <K> Object2IntMap<K> intMapOf(K key, int value) {
        return Object2IntMaps.singleton(key, (int)value);
    }

    public static <K> Object2IntMap<K> intMapOf(K key, int value, K key2, int value2) {
        Object2IntArrayMap intMap = new Object2IntArrayMap(2);
        intMap.put(key, value);
        intMap.put(key2, value2);
        return intMap;
    }

    public static <K> Object2IntMap<K> intMapOf(K key, int value, K key2, int value2, K key3, int value3) {
        Object2IntArrayMap intMap = new Object2IntArrayMap(3);
        intMap.put(key, value);
        intMap.put(key2, value2);
        intMap.put(key3, value3);
        return intMap;
    }

    public static <K> Object2IntMap<K> intMapOf(K key, int value, K key2, int value2, K key3, int value3, K key4, int value4) {
        Object2IntArrayMap intMap = new Object2IntArrayMap(3);
        intMap.put(key, value);
        intMap.put(key2, value2);
        intMap.put(key3, value3);
        intMap.put(key4, value4);
        return intMap;
    }

    public static long consumePlayerFuel(Player player, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long minFuel) {
        IItemHandler inv;
        if (player.isCreative() || minFuel == 0L) {
            return minFuel;
        }
        IItemHandler curios = (IItemHandler)player.getCapability(IntegrationHelper.CURIO_ITEM_HANDLER);
        if (curios != null) {
            int slots = curios.getSlots();
            for (int i = 0; i < slots; ++i) {
                long actualExtracted = EMCHelper.tryExtract(curios.getStackInSlot(i), minFuel);
                if (actualExtracted <= 0L) continue;
                player.containerMenu.broadcastChanges();
                return actualExtracted;
            }
        }
        if ((inv = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            boolean metRequirement = false;
            long emcConsumed = 0L;
            int slots = inv.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                long actualExtracted = EMCHelper.tryExtract(stack, minFuel);
                if (actualExtracted > 0L) {
                    player.containerMenu.broadcastChanges();
                    return actualExtracted;
                }
                if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
                long emc = IEMCProxy.INSTANCE.getValue(stack);
                int toRemove = Mth.ceil((double)((double)(minFuel - emcConsumed) / (double)emc));
                int actualRemoved = Math.min(stack.getCount(), toRemove);
                if (actualRemoved <= 0) continue;
                map.put(i, actualRemoved);
                metRequirement = (emcConsumed += emc * (long)actualRemoved) >= minFuel;
            }
            if (metRequirement) {
                ObjectIterator iterator = Int2IntMaps.fastIterator((Int2IntMap)map);
                while (iterator.hasNext()) {
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
                    inv.extractItem(entry.getIntKey(), entry.getIntValue(), false);
                }
                player.containerMenu.broadcastChanges();
                return emcConsumed;
            }
        }
        return -1L;
    }

    private static long tryExtract(@NotNull ItemStack stack, long minFuel) {
        long simulatedExtraction;
        IItemEmcHolder emcHolder = (IItemEmcHolder)stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder != null && (simulatedExtraction = emcHolder.extractEmc(stack, minFuel, IEmcStorage.EmcAction.SIMULATE)) >= minFuel) {
            return emcHolder.extractEmc(stack, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE);
        }
        return 0L;
    }

    public static String formatEmc(Number emc) {
        return EMC_FORMATTER.format(emc);
    }

    public static String formatEmc(double emc) {
        return EMC_FORMATTER.format(emc);
    }

    public static String formatEmc(long emc) {
        return EMC_FORMATTER.format(emc);
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcSellValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long originalValue) {
        if (originalValue == 0L) {
            return 0L;
        }
        long emc = Mth.lfloor((double)((double)originalValue * ProjectEConfig.server.difficulty.covalenceLoss.get()));
        if (emc < 1L) {
            emc = ProjectEConfig.server.difficulty.covalenceLossRounding.get() ? 1L : 0L;
        }
        return emc;
    }

    public static Component getEmcTextComponent(long emc, int stackSize) {
        String sell;
        String value;
        PELang prefix;
        if (ProjectEConfig.server.difficulty.covalenceLoss.get() == 1.0) {
            String value2;
            PELang prefix2;
            if (stackSize > 1) {
                prefix2 = PELang.EMC_STACK_TOOLTIP;
                value2 = EMCHelper.formatEmc(BigInteger.valueOf(emc).multiply(BigInteger.valueOf(stackSize)));
            } else {
                prefix2 = PELang.EMC_TOOLTIP;
                value2 = EMCHelper.formatEmc(emc);
            }
            return prefix2.translateColored(ChatFormatting.YELLOW, ChatFormatting.WHITE, value2);
        }
        long emcSellValue = EMCHelper.getEmcSellValue(emc);
        if (stackSize > 1) {
            prefix = PELang.EMC_STACK_TOOLTIP_WITH_SELL;
            BigInteger bigIntStack = BigInteger.valueOf(stackSize);
            value = EMCHelper.formatEmc(BigInteger.valueOf(emc).multiply(bigIntStack));
            sell = EMCHelper.formatEmc(BigInteger.valueOf(emcSellValue).multiply(bigIntStack));
        } else {
            prefix = PELang.EMC_TOOLTIP_WITH_SELL;
            value = EMCHelper.formatEmc(emc);
            sell = EMCHelper.formatEmc(emcSellValue);
        }
        return prefix.translateColored(ChatFormatting.YELLOW, ChatFormatting.WHITE, value, ChatFormatting.BLUE, sell);
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEMCPerDurability(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0L;
        }
        if (stack.isDamageableItem()) {
            ItemStack stackCopy = stack.copy();
            stackCopy.setDamageValue(0);
            long emc = (long)Math.ceil((double)IEMCProxy.INSTANCE.getValue(stackCopy) / (double)stack.getMaxDamage());
            return Math.max(emc, 1L);
        }
        return 1L;
    }

    public static long removeFractionalEMC(ItemStack stack, double amount) {
        double unprocessedEMC = (Double)stack.getOrDefault(PEDataComponentTypes.UNPROCESSED_EMC, (Object)0.0);
        long toRemove = (long)(unprocessedEMC += amount);
        stack.set(PEDataComponentTypes.UNPROCESSED_EMC, (Object)(unprocessedEMC -= (double)toRemove));
        return toRemove;
    }
}

