/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.PETags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityRandomizerHelper {
    @Nullable
    public static Mob getRandomEntity(Level level, Mob toRandomize) {
        Rabbit rabbit;
        EntityType entType = toRandomize.getType();
        boolean isPeaceful = entType.is(PETags.Entities.RANDOMIZER_PEACEFUL);
        boolean isHostile = entType.is(PETags.Entities.RANDOMIZER_HOSTILE);
        if (isPeaceful && isHostile && toRandomize instanceof Rabbit && (rabbit = (Rabbit)toRandomize).getVariant() == Rabbit.Variant.EVIL) {
            isPeaceful = false;
        }
        if (isPeaceful) {
            return EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_PEACEFUL);
        }
        if (isHostile) {
            Mob ent = EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_HOSTILE);
            if (ent instanceof Rabbit) {
                Rabbit rabbit2 = (Rabbit)ent;
                rabbit2.setVariant(Rabbit.Variant.EVIL);
            }
            return ent;
        }
        return null;
    }

    @Nullable
    private static Mob createRandomEntity(Level level, Entity current, TagKey<EntityType<?>> type) {
        EntityType<?> newType;
        EntityType currentType = current.getType();
        if (currentType == (newType = EntityRandomizerHelper.getRandomTagEntry(level.getRandom(), BuiltInRegistries.ENTITY_TYPE, type, currentType))) {
            return null;
        }
        Entity newEntity = newType.create(level);
        if (newEntity instanceof Mob) {
            return (Mob)newEntity;
        }
        if (newEntity != null) {
            newEntity.discard();
            PECore.LOGGER.warn("Invalid Entity type {} in mob randomizer tag {}. All entities in this tag are expected to be a mob.", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(newType), (Object)type.location());
        }
        return null;
    }

    private static EntityType<?> getRandomTagEntry(RandomSource random, Registry<EntityType<?>> registry, TagKey<EntityType<?>> tagKey, EntityType<?> toExclude) {
        Optional<EntityType> obj;
        Optional optionalTag = registry.getTag(tagKey);
        if (optionalTag.isEmpty()) {
            return toExclude;
        }
        HolderSet.Named tag = (HolderSet.Named)optionalTag.get();
        int size = tag.size();
        if (size == 0 || size == 1 && toExclude.is(tagKey)) {
            return toExclude;
        }
        while ((obj = tag.getRandomElement(random).map(Holder::value)).isPresent() && obj.get().equals(toExclude)) {
        }
        return obj.orElse(toExclude);
    }
}

