/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHelper {
    public static InteractionResultHolder<ItemStack> actionResultFromType(InteractionResult type, ItemStack stack) {
        return switch (type) {
            case InteractionResult.SUCCESS -> InteractionResultHolder.success((Object)stack);
            case InteractionResult.CONSUME -> InteractionResultHolder.consume((Object)stack);
            case InteractionResult.FAIL -> InteractionResultHolder.fail((Object)stack);
            default -> InteractionResultHolder.pass((Object)stack);
        };
    }

    public static boolean compactInventory(IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        int slots = inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            temp.add(stackInSlot);
            inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        for (ItemStack s : temp) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)s, (boolean)false);
        }
        return temp.isEmpty();
    }

    public static IItemHandlerModifiable immutableCopy(IItemHandler toCopy) {
        int slots = toCopy.getSlots();
        final ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots);
        for (int i = 0; i < slots; ++i) {
            list.add(toCopy.getStackInSlot(i).copy());
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            }

            public int getSlots() {
                return list.size();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)list.get(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return this.getStackInSlot(slot).getMaxStackSize();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }
        };
    }

    public static boolean isRepairableDamagedItem(ItemStack stack) {
        return stack.isDamageableItem() && stack.isRepairable() && stack.getDamageValue() > 0;
    }

    public static int simulateFit(NonNullList<ItemStack> inv, ItemStack stack) {
        int remainder = stack.getCount();
        for (ItemStack invStack : inv) {
            int amountSlotNeeds;
            if (invStack.isEmpty()) {
                return 0;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)invStack) || (amountSlotNeeds = invStack.getMaxStackSize() - invStack.getCount()) <= 0) continue;
            if (remainder <= amountSlotNeeds) {
                return 0;
            }
            remainder -= amountSlotNeeds;
        }
        return remainder;
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(size);
    }

    public static BlockState stackToState(ItemStack stack, @Nullable BlockPlaceContext context) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (context == null) {
                return blockItem.getBlock().defaultBlockState();
            }
            return blockItem.getBlock().getStateForPlacement(context);
        }
        return null;
    }
}

