/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NovaExplosion
extends Explosion {
    private final Level level;

    public NovaExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius, Explosion.BlockInteraction mode) {
        super(level, entity, x, y, z, radius, false, mode);
        this.level = level;
    }

    public void finalizeExplosion(boolean spawnParticles) {
        this.finalizeExplosion();
    }

    public List<BlockPos> finalizeExplosion() {
        ArrayList<BlockPos> particlePositions = new ArrayList<BlockPos>();
        boolean interactsWithBlocks = this.interactsWithBlocks();
        List toBlow = this.getToBlow();
        if (interactsWithBlocks) {
            this.level.getProfiler().push("explosion_blocks");
            NonNullList allDrops = NonNullList.create();
            Util.shuffle((List)toBlow, (RandomSource)this.level.random);
            for (BlockPos pos : toBlow) {
                BlockState state = this.level.getBlockState(pos);
                if (!state.isAir()) {
                    particlePositions.add(pos);
                }
                state.onExplosionHit(this.level, pos, (Explosion)this, (stack, position) -> allDrops.add(stack));
            }
            LivingEntity placer = this.getIndirectSourceEntity();
            WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.level, placer == null ? this.center() : placer.position());
            this.level.getProfiler().pop();
        }
        return particlePositions;
    }
}

