/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import moze_intel.projecte.PECore;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.network.packets.to_client.NovaExplosionSyncPKT;
import moze_intel.projecte.utils.NovaExplosion;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.util.ItemStackMap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldHelper {
    private static final Predicate<Entity> SWRG_REPEL_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_SWRG);
    private static final Map<Block, IntegerProperty> AGE_PROPERTIES = new Reference2ObjectOpenHashMap();

    public static void clearCachedAgeProperties() {
        AGE_PROPERTIES.clear();
    }

    public static void createLootDrop(List<ItemStack> drops, Level level, BlockPos pos) {
        WorldHelper.createLootDrop(drops, level, pos.getX(), pos.getY(), pos.getZ());
    }

    public static void createLootDrop(List<ItemStack> drops, Level level, Vec3 pos) {
        WorldHelper.createLootDrop(drops, level, pos.x(), pos.y(), pos.z());
    }

    public static void createLootDrop(List<ItemStack> drops, Level level, double x, double y, double z) {
        if (!drops.isEmpty()) {
            Map knownItems = ItemStackMap.createTypeAndTagMap();
            for (ItemStack drop : drops) {
                if (drop.isEmpty()) continue;
                int dropCount = drop.getCount();
                ItemEntity itemEntity = (ItemEntity)knownItems.get(drop);
                if (itemEntity != null) {
                    int availableRoom = drop.getMaxStackSize() - itemEntity.getItem().getCount();
                    if (dropCount <= availableRoom) {
                        itemEntity.getItem().grow(dropCount);
                        if (dropCount != availableRoom) continue;
                        knownItems.remove(drop);
                        level.addFreshEntity((Entity)itemEntity);
                        continue;
                    }
                    itemEntity.getItem().grow(availableRoom);
                    knownItems.remove(drop);
                    level.addFreshEntity((Entity)itemEntity);
                    dropCount -= availableRoom;
                }
                itemEntity = new ItemEntity(level, x, y, z, drop.copyWithCount(dropCount));
                knownItems.put(drop, itemEntity);
            }
            for (ItemEntity itemEntity : knownItems.values()) {
                level.addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static void createNovaExplosion(Level level, Entity exploder, double x, double y, double z, float power) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Explosion.BlockInteraction mode = level.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
            NovaExplosion explosion = new NovaExplosion(level, exploder, x, y, z, power, mode);
            if (!EventHooks.onExplosionStart((Level)level, (Explosion)explosion)) {
                explosion.explode();
                List<BlockPos> particlePositions = explosion.finalizeExplosion();
                NovaExplosionSyncPKT packet = new NovaExplosionSyncPKT(explosion.center(), explosion.radius(), (Holder<SoundEvent>)explosion.getExplosionSound(), particlePositions);
                for (ServerPlayer player : serverLevel.players()) {
                    if (!(player.distanceToSqr(x, y, z) < 4096.0)) continue;
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public static void drainFluid(@Nullable Player player, Level level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            bucketPickup.pickupBlock(player, (LevelAccessor)level, pos, state);
        }
    }

    public static void dropInventory(@Nullable IItemHandler inv, Level level, BlockPos pos) {
        if (inv != null) {
            int slots = inv.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
            }
        }
    }

    public static void extinguishNearby(Level level, Player player) {
        for (BlockPos pos : WorldHelper.getPositionsInBox(player.getBoundingBox().inflate(1.0))) {
            if (!level.getBlockState(pos = pos.immutable()).is(Blocks.FIRE) || !PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos)) continue;
            level.removeBlock(pos, false);
        }
    }

    public static void freezeInBoundingBox(Level level, AABB box, Player player, boolean random) {
        for (BlockPos pos : WorldHelper.getPositionsInBox(box)) {
            BlockState state = level.getBlockState(pos);
            pos = pos.immutable();
            if (state.is(Blocks.WATER) && (!random || level.random.nextInt(128) == 0)) {
                if (player != null) {
                    PlayerHelper.checkedReplaceBlock((ServerPlayer)player, level, pos, Blocks.ICE.defaultBlockState());
                    continue;
                }
                level.setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                continue;
            }
            if (!Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP)) continue;
            BlockPos up = pos.above();
            BlockState stateUp = level.getBlockState(up);
            BlockState newState = null;
            if (stateUp.isAir() && (!random || level.random.nextInt(128) == 0)) {
                newState = Blocks.SNOW.defaultBlockState();
            } else if (stateUp.is(Blocks.SNOW) && (Integer)stateUp.getValue((Property)SnowLayerBlock.LAYERS) < 8 && level.random.nextInt(512) == 0) {
                newState = (BlockState)stateUp.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf((Integer)stateUp.getValue((Property)SnowLayerBlock.LAYERS) + 1));
            }
            if (newState == null) continue;
            if (player != null) {
                PlayerHelper.checkedReplaceBlock((ServerPlayer)player, level, up, newState);
                continue;
            }
            level.setBlockAndUpdate(up, newState);
        }
    }

    public static boolean isLiquidContainerForFluid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.getBlock();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, level, pos, state, fluid);
    }

    public static void placeFluid(@Nullable Player player, Level level, BlockPos pos, Direction sideHit, FlowingFluid fluid, boolean checkWaterVaporize) {
        if (WorldHelper.isLiquidContainerForFluid(player, (BlockGetter)level, pos, level.getBlockState(pos), (Fluid)fluid)) {
            WorldHelper.placeFluid(player, level, pos, fluid, checkWaterVaporize);
        } else {
            WorldHelper.placeFluid(player, level, pos.relative(sideHit), fluid, checkWaterVaporize);
        }
    }

    public static void placeFluid(@Nullable Player player, Level level, BlockPos pos, FlowingFluid fluid, boolean checkWaterVaporize) {
        BlockState blockState = level.getBlockState(pos);
        if (checkWaterVaporize && level.dimensionType().ultraWarm() && fluid.is(FluidTags.WATER)) {
            level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else if (WorldHelper.isLiquidContainerForFluid(player, (BlockGetter)level, pos, blockState, (Fluid)fluid)) {
            ((LiquidBlockContainer)blockState.getBlock()).placeLiquid((LevelAccessor)level, pos, blockState, fluid.getSource(false));
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, pos);
        } else {
            if (blockState.canBeReplaced((Fluid)fluid) && !blockState.liquid()) {
                level.destroyBlock(pos, true);
            }
            if (player == null) {
                level.setBlockAndUpdate(pos, fluid.defaultFluidState().createLegacyBlock());
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            } else if (PlayerHelper.checkedPlaceBlock(player, level, pos, fluid.defaultFluidState().createLegacyBlock())) {
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, pos);
            }
        }
    }

    public static void copySignData(Level level, BlockPos pos, SignBlockEntity oldSign) {
        BlockEntity blockEntity;
        if (oldSign != null && (blockEntity = level.getBlockEntity(pos)) instanceof SignBlockEntity) {
            SignBlockEntity newSign = (SignBlockEntity)blockEntity;
            newSign.setText(oldSign.getText(true), true);
            newSign.setText(oldSign.getText(false), false);
            newSign.setAllowedPlayerEditor(oldSign.getPlayerWhoMayEdit());
            newSign.setWaxed(oldSign.isWaxed());
        }
    }

    public static AABB getBroadDeepBox(BlockPos pos, Direction direction, int offset) {
        return WorldHelper.getBroadDeepBox(pos, direction, offset, 2 * offset);
    }

    public static AABB getBroadDeepBox(BlockPos pos, Direction direction, int breadth, int depth) {
        AABB box = WorldHelper.getBroadBox(pos, direction, breadth);
        if (depth == 0) {
            return box;
        }
        return box.expandTowards((double)(depth * -direction.getStepX()), (double)(depth * -direction.getStepY()), (double)(depth * -direction.getStepZ()));
    }

    public static AABB getDeepBox(BlockPos pos, Direction direction, int depth) {
        return WorldHelper.getBroadDeepBox(pos, direction, 1, depth);
    }

    public static AABB getBroadBox(BlockPos pos, Direction direction, int breadth) {
        AABB point = new AABB(pos);
        if (breadth == 0) {
            return point;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.EAST, Direction.WEST -> point.inflate(0.0, (double)breadth, (double)breadth);
            case Direction.UP, Direction.DOWN -> point.inflate((double)breadth, 0.0, (double)breadth);
            case Direction.SOUTH, Direction.NORTH -> point.inflate((double)breadth, (double)breadth, 0.0);
        };
    }

    public static AABB getFlatYBox(BlockPos pos, int offset) {
        return WorldHelper.getBroadBox(pos, Direction.UP, offset);
    }

    public static Iterable<BlockPos> getPositionsInBox(AABB box) {
        float epsilon = 1.0E-6f;
        return BlockPos.betweenClosed((int)Mth.floor((double)(box.minX + (double)epsilon)), (int)Mth.floor((double)(box.minY + (double)epsilon)), (int)Mth.floor((double)(box.minZ + (double)epsilon)), (int)Mth.floor((double)(box.maxX - (double)epsilon)), (int)Mth.floor((double)(box.maxY - (double)epsilon)), (int)Mth.floor((double)(box.maxZ - (double)epsilon)));
    }

    public static Iterable<BlockPos> horizontalPositionsAround(BlockPos pos, int horizontalRadius) {
        return WorldHelper.positionsAround(pos, horizontalRadius, 0, horizontalRadius);
    }

    public static Iterable<BlockPos> positionsAround(BlockPos pos, int radius) {
        return WorldHelper.positionsAround(pos, radius, radius, radius);
    }

    public static Iterable<BlockPos> positionsAround(BlockPos pos, int xRadius, int yRadius, int zRadius) {
        return BlockPos.betweenClosed((BlockPos)pos.offset(-xRadius, -yRadius, -zRadius), (BlockPos)pos.offset(xRadius, yRadius, zRadius));
    }

    public static List<BlockEntity> getBlockEntitiesWithinAABB(Level level, AABB box, Predicate<BlockEntity> predicate) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (BlockPos pos : WorldHelper.getPositionsInBox(box)) {
            BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, pos);
            if (blockEntity == null || !predicate.test(blockEntity)) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public static void gravitateEntityTowards(Entity ent, Vec3 target) {
        Vec3 difference = target.subtract(ent.position());
        double vel = 1.0 - difference.length() / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.addDeltaMovement(difference.normalize().scale(vel).multiply(0.1, 0.2, 0.1));
        }
    }

    public static void growNearbyRandomly(boolean harvest, Level level, Player player) {
        WorldHelper.growNearbyRandomly(harvest, level, player.getBoundingBox().inflate(5.0, 3.0, 5.0), player);
    }

    public static void growNearbyRandomly(boolean harvest, Level level, AABB box, @Nullable Player player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean grewWater = false;
        int chance = harvest ? 16 : 32;
        for (BlockPos currentPos : WorldHelper.getPositionsInBox(box)) {
            BlockState state = level.getBlockState(currentPos = currentPos.immutable());
            Block block = state.getBlock();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)block;
                if (growable.isValidBonemealTarget((LevelReader)level, currentPos, state)) {
                    if (!ProjectEConfig.server.items.harvBandIndirect.get() && WorldHelper.onlyAffectsOtherBlocks(state.getBlock()) || level.random.nextInt(chance) != 0 || !growable.isBonemealSuccess(level, level.random, currentPos, state)) continue;
                    growable.performBonemeal(serverLevel, level.random, currentPos, state);
                    level.levelEvent(1505, currentPos, 0);
                    continue;
                }
                WorldHelper.tryHarvest(level, currentPos, state, player, harvest);
                continue;
            }
            if (WorldHelper.isPlantable(state)) {
                if (state.isRandomlyTicking() && level.random.nextInt(chance / 4) == 0) {
                    int ticks;
                    Block initialType = state.getBlock();
                    int n = ticks = harvest ? 8 : 4;
                    for (int i = 0; i < ticks; ++i) {
                        state.randomTick(serverLevel, currentPos, level.random);
                        state = level.getBlockState(currentPos);
                        if (!state.is(initialType)) break;
                    }
                    if (!state.is(initialType)) continue;
                }
                WorldHelper.tryHarvest(level, currentPos, state, player, harvest);
                continue;
            }
            if (grewWater || level.random.nextInt(512) != 0 || !BoneMealItem.growWaterPlant((ItemStack)ItemStack.EMPTY, (Level)level, (BlockPos)currentPos, null)) continue;
            level.levelEvent(1505, currentPos, 0);
            grewWater = true;
        }
    }

    private static void tryHarvest(Level level, BlockPos pos, BlockState state, @Nullable Player player, boolean harvest) {
        ServerPlayer serverPlayer;
        if (harvest && WorldHelper.shouldHarvest(level, pos, state) && (player == null || PlayerHelper.hasEditPermission(player, level, pos)) && (!(player instanceof ServerPlayer) || PlayerHelper.checkBreakPermission(serverPlayer = (ServerPlayer)player, level, pos))) {
            level.destroyBlock(pos, true, (Entity)player);
        }
    }

    private static boolean shouldHarvest(Level level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (state.is(PETags.Blocks.BLACKLIST_HARVEST) || WorldHelper.isUnharvestableImplementation(block)) {
            return false;
        }
        if (block instanceof BambooStalkBlock || block instanceof SugarCaneBlock) {
            return level.getBlockState(pos.below()).is(block);
        }
        if (block instanceof CactusBlock) {
            return !level.getBlockState(pos.below()).is(block) && level.getBlockState(pos.above()).is(block);
        }
        if (block instanceof GrowingPlantBlock) {
            GrowingPlantBlock growingPlantBlock = (GrowingPlantBlock)block;
            return level.getBlockState(pos.relative(growingPlantBlock.growthDirection, -1)).is(growingPlantBlock.getBodyBlock());
        }
        if (block instanceof LeavesBlock) {
            LeavesBlock leavesBlock = (LeavesBlock)block;
            return leavesBlock.decaying(state);
        }
        if (block instanceof VineBlock) {
            return level.getBlockState(pos.above()).is(block);
        }
        if (block instanceof GlowLichenBlock) {
            // empty if block
        }
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        IntegerProperty ageProperty = null;
        if (AGE_PROPERTIES.containsKey(block)) {
            ageProperty = AGE_PROPERTIES.get(block);
        } else {
            for (Map.Entry entry : state.getValues().entrySet()) {
                IntegerProperty intProperty;
                if (!((Property)entry.getKey()).getName().equals("age")) continue;
                Object v = entry.getValue();
                if (!(v instanceof IntegerProperty)) break;
                ageProperty = intProperty = (IntegerProperty)v;
                break;
            }
            AGE_PROPERTIES.put(block, ageProperty);
        }
        return ageProperty == null || (Integer)state.getValue((Property)ageProperty) == ageProperty.max;
    }

    public static boolean isUnharvestableImplementation(Block block) {
        return block instanceof StemBlock || block instanceof AttachedStemBlock || block instanceof WaterlilyBlock || WorldHelper.onlyAffectsOtherBlocks(block);
    }

    private static boolean isPlantable(BlockState state) {
        return state.is(PETags.Blocks.OVERRIDE_PLANTABLE) || WorldHelper.isPlantableImplementation(state.getBlock());
    }

    public static boolean isPlantableImplementation(Block block) {
        return block instanceof CactusBlock || block instanceof SugarCaneBlock || block instanceof VineBlock || block instanceof BushBlock;
    }

    public static boolean isCrop(BlockState state) {
        if (state.getBlock() instanceof BonemealableBlock) {
            return ProjectEConfig.server.items.harvBandIndirect.get() || !WorldHelper.onlyAffectsOtherBlocks(state.getBlock());
        }
        return WorldHelper.isPlantable(state);
    }

    private static boolean onlyAffectsOtherBlocks(Block block) {
        return block instanceof GrassBlock || block instanceof NyliumBlock || block instanceof MossBlock;
    }

    private static <DATA> boolean validState(DATA data, BiPredicate<BlockState, DATA> stateChecker, BlockState state, Level level, BlockPos pos, Player player) {
        return stateChecker.test(state, data) && state.getDestroySpeed((BlockGetter)level, pos) != -1.0f && PlayerHelper.hasEditPermission(player, level, pos);
    }

    public static <DATA> int harvestVein(Level level, Player player, ItemStack stack, AABB area, List<ItemStack> currentDrops, DATA data, BiPredicate<BlockState, DATA> stateChecker) {
        BlockState state2;
        int numMined = 0;
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        record TargetInfo(BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity) {
            public static TargetInfo create(Level level, BlockPos pos, BlockState state, Player player) {
                BlockEntity blockEntity = state.hasBlockEntity() ? WorldHelper.getBlockEntity((BlockGetter)level, pos) : null;
                return new TargetInfo(pos, state.getBlock().playerWillDestroy(level, pos, state, player), blockEntity);
            }
        }
        ArrayDeque<TargetInfo> frontier = new ArrayDeque<TargetInfo>();
        VeinStateChecker<Object> validState = level.isClientSide ? WorldHelper::validState : (dat, checker, state, lvl, pos, p) -> WorldHelper.validState(dat, checker, state, lvl, pos, p) && PlayerHelper.checkBreakPermission((ServerPlayer)p, lvl, pos);
        for (BlockPos pos2 : WorldHelper.getPositionsInBox(area)) {
            state2 = level.getBlockState(pos2);
            if (validState.test(data, stateChecker, state2, level, pos2, player)) {
                if (level.isClientSide) {
                    return 1;
                }
                pos2 = pos2.immutable();
                frontier.add(TargetInfo.create(level, pos2, state2, player));
            }
            traversed.add(pos2.immutable());
        }
        while (!frontier.isEmpty()) {
            BlockPos pos2;
            TargetInfo targetInfo = (TargetInfo)frontier.poll();
            pos2 = targetInfo.pos();
            state2 = targetInfo.state();
            if (!state2.onDestroyedByPlayer(level, pos2, player, true, level.getFluidState(pos2))) continue;
            Block block = state2.getBlock();
            block.destroy((LevelAccessor)level, pos2, state2);
            player.awardStat(Stats.BLOCK_MINED.get((Object)block));
            currentDrops.addAll(Block.getDrops((BlockState)state2, (ServerLevel)((ServerLevel)level), (BlockPos)pos2, (BlockEntity)targetInfo.blockEntity(), (Entity)player, (ItemStack)stack));
            if (++numMined >= 250) break;
            for (BlockPos nextPos : WorldHelper.positionsAround(pos2, 1)) {
                BlockState nextState;
                if (!traversed.add(nextPos = nextPos.immutable()) || !WorldHelper.isBlockLoaded((BlockGetter)level, nextPos) || !validState.test(data, stateChecker, nextState = level.getBlockState(nextPos), level, nextPos, player)) continue;
                frontier.add(TargetInfo.create(level, nextPos, nextState, player));
            }
        }
        return numMined;
    }

    public static void igniteNearby(Level level, Player player) {
        for (BlockPos pos : WorldHelper.getPositionsInBox(player.getBoundingBox().inflate(8.0, 5.0, 8.0))) {
            if (level.random.nextInt(128) != 0 || !level.isEmptyBlock(pos)) continue;
            PlayerHelper.checkedPlaceBlock(player, level, pos.immutable(), Blocks.FIRE.defaultBlockState());
        }
    }

    public static boolean validRepelEntity(Entity entity, TagKey<EntityType<?>> blacklistTag) {
        if (!entity.isSpectator() && !entity.getType().is(blacklistTag)) {
            if (entity instanceof Projectile) {
                return !entity.onGround();
            }
            return entity instanceof Mob;
        }
        return false;
    }

    public static void repelEntitiesSWRG(Level level, AABB effectBounds, Player player) {
        Vec3 playerVec = player.position();
        for (Entity ent : level.getEntitiesOfClass(Entity.class, effectBounds, SWRG_REPEL_PREDICATE)) {
            if (ent instanceof Projectile) {
                Projectile projectile = (Projectile)ent;
                Entity owner = projectile.getOwner();
                if (level.isClientSide() && owner == null || owner != null && player.getUUID().equals(owner.getUUID())) continue;
            }
            WorldHelper.repelEntity(playerVec, ent);
        }
    }

    public static void repelEntity(Vec3 vec, Entity entity) {
        double distance = vec.distanceTo(entity.position()) + 0.1;
        entity.push(entity.position().subtract(vec).scale(1.0 / (1.5 * distance)));
    }

    @NotNull
    public static InteractionResult igniteBlock(UseOnContext ctx) {
        Direction side;
        BlockPos pos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)(pos = ctx.getClickedPos()), (Direction)(side = ctx.getClickedFace()))) {
            if (!level.isClientSide && PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos)) {
                level.setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos));
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            BlockState state = level.getBlockState(pos);
            if (state.getToolModifiedState(ctx, ItemAbilities.FIRESTARTER_LIGHT, true) != null) {
                BlockState modifiedState;
                if (!level.isClientSide && PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos) && (modifiedState = state.getToolModifiedState(ctx, ItemAbilities.FIRESTARTER_LIGHT, false)) != null) {
                    level.setBlockAndUpdate(pos, modifiedState);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (state.isFlammable((BlockGetter)level, pos, side)) {
                if (!level.isClientSide && PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos)) {
                    state.onCaughtFire(level, pos, side, (LivingEntity)player);
                    if (state.getBlock() instanceof TntBlock) {
                        level.removeBlock(pos, false);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, @NotNull BlockPos pos) {
        return WorldHelper.isChunkLoaded(world, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, ChunkPos chunkPos) {
        return WorldHelper.isChunkLoaded(world, chunkPos.x, chunkPos.z);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, int chunkX, int chunkZ) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelAccessor) {
            LevelAccessor accessor = (LevelAccessor)world;
            return accessor.hasChunk(chunkX, chunkZ);
        }
        return world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).isInWorldBounds(pos)) {
                return false;
            }
            return WorldHelper.isChunkLoaded(reader, pos);
        }
        return true;
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <CAP, CONTEXT> CAP getCapability(@Nullable Level level, BlockCapability<CAP, CONTEXT> cap, BlockPos pos, CONTEXT context) {
        return WorldHelper.getCapability(level, cap, pos, null, null, context);
    }

    @Nullable
    @Contract(value="null, _, _, _, _, _ -> null")
    public static <CAP, CONTEXT> CAP getCapability(@Nullable Level level, BlockCapability<CAP, CONTEXT> cap, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity, CONTEXT context) {
        if (!WorldHelper.isBlockLoaded((BlockGetter)level, pos)) {
            return null;
        }
        return (CAP)level.getCapability(cap, pos, state, blockEntity, context);
    }

    @Nullable
    public static BlockEntity getBlockEntity(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        if (!WorldHelper.isBlockLoaded(level, pos)) {
            return null;
        }
        return level.getBlockEntity(pos);
    }

    @Nullable
    public static <BE extends BlockEntity> BE getBlockEntity(@NotNull Class<BE> clazz, @Nullable BlockGetter level, @NotNull BlockPos pos) {
        return WorldHelper.getBlockEntity(clazz, level, pos, false);
    }

    @Nullable
    public static <BE extends BlockEntity> BE getBlockEntity(@NotNull Class<BE> clazz, @Nullable BlockGetter level, @NotNull BlockPos pos, boolean logWrongType) {
        BlockEntity blockEntity = WorldHelper.getBlockEntity(level, pos);
        if (blockEntity == null) {
            return null;
        }
        if (clazz.isInstance(blockEntity)) {
            return (BE)((BlockEntity)clazz.cast(blockEntity));
        }
        if (logWrongType) {
            PECore.LOGGER.warn("Unexpected block entity class at {}, expected {}, but found: {}", new Object[]{pos, clazz, blockEntity.getClass()});
        }
        return null;
    }

    @FunctionalInterface
    private static interface VeinStateChecker<DATA> {
        public boolean test(DATA var1, BiPredicate<BlockState, DATA> var2, BlockState var3, Level var4, BlockPos var5, Player var6);
    }
}

