/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class PancakeBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final Integer MAX_SERVINGS = 6;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)(MAX_SERVINGS - 1));
    public final Supplier<Item> servingItem;
    protected static final VoxelShape PLATE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape[] PANCAKES_SHAPES = new VoxelShape[]{Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), (BooleanOp)BooleanOp.OR)};

    public PancakeBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack heldStack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (heldStack.is(Tags.Items.TOOLS_SHEAR)) {
            return this.takeServing(level, pos, state, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.consumeServing(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeServing(level, pos, state, player);
    }

    protected ItemInteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player) {
        Direction direction = player.getDirection().getOpposite();
        PancakeBlock.spawnItemEntity(level, this.getServingItem(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.3, (double)pos.getZ() + 0.5, (double)direction.getStepX() * 0.15, 0.05, (double)direction.getStepZ() * 0.15);
        this.removeServing(level, pos, state);
        level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult consumeServing(Level level, BlockPos pos, BlockState state, Player playerIn) {
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack servingStack = this.getServingItem();
        FoodProperties foodProperties = servingStack.getFoodProperties((LivingEntity)playerIn);
        if (foodProperties != null) {
            playerIn.getFoodData().eat(foodProperties);
            for (FoodProperties.PossibleEffect effect : foodProperties.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        this.removeServing(level, pos, state);
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    private void removeServing(Level level, BlockPos pos, BlockState state) {
        int servingsTaken = (Integer)state.getValue((Property)SERVINGS);
        if (servingsTaken < MAX_SERVINGS - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servingsTaken + 1)), MAX_SERVINGS - 1);
        } else {
            level.destroyBlock(pos, true);
        }
    }

    public ItemStack getServingItem() {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    private static void spawnItemEntity(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.setDeltaMovement(xMotion, yMotion, zMotion);
        level.addFreshEntity((Entity)entity);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return PANCAKES_SHAPES[(Integer)state.getValue((Property)SERVINGS)];
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SERVINGS});
    }

    public int getAnalogOutputSignal(BlockState blockState, @NotNull Level level, @NotNull BlockPos pos) {
        return (Integer)blockState.getValue((Property)SERVINGS);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }
}

