/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.datagen;

import com.phantomwing.rusticpancakes.block.ModBlocks;
import com.phantomwing.rusticpancakes.block.custom.PancakeBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "rusticpancakes", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.pancakeBlock((Block)ModBlocks.PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.HONEY_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.CHOCOLATE_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.CHERRY_BLOSSOM_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.VEGETABLE_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.PUMPKIN_PANCAKES.get());
    }

    private void pancakeBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int servings = (Integer)state.getValue((Property)PancakeBlock.SERVINGS);
            String suffix = "_stage" + servings;
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + suffix)).rotationY(((int)((Direction)state.getValue((Property)PancakeBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    private ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"rusticpancakes", (String)("block/" + path));
    }

    private ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }
}

