/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.datagen;

import com.phantomwing.rusticpancakes.block.custom.PancakeBlock;
import com.phantomwing.rusticpancakes.item.ModItems;
import com.phantomwing.rusticpancakes.tags.CommonTags;
import com.phantomwing.rusticpancakes.tags.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        this.buildCraftingRecipes(output);
    }

    private void buildCraftingRecipes(@NotNull RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.BATTER, (int)1).requires((ItemLike)Items.BOWL).requires(CommonTags.FOODS_MILK).requires(Tags.Items.EGGS).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MILK_BUCKET), ModRecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SYRUP, (int)1).requires((ItemLike)Items.GLASS_BOTTLE).requires(ModTags.Items.SYRUP_INGREDIENTS).requires((ItemLike)Items.SUGAR).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MILK_BUCKET), ModRecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.SYRUP, (ItemLike)Items.SUGAR, 3);
        ModRecipeProvider.pancakeRecipes(output, ModItems.PANCAKES, ModItems.PANCAKE, Ingredient.of(ModTags.Items.SYRUP), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.HONEY_PANCAKES, ModItems.HONEY_PANCAKE, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHOCOLATE_PANCAKES, ModItems.CHOCOLATE_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.VEGETABLE_PANCAKES, ModItems.VEGETABLE_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), ModRecipeProvider.vegetablesPatch());
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHERRY_BLOSSOM_PANCAKES, ModItems.CHERRY_BLOSSOM_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), Ingredient.of(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.PUMPKIN_PANCAKES, ModItems.PUMPKIN_PANCAKE, Ingredient.of(ModTags.Items.SYRUP), Ingredient.of(CommonTags.FOODS_PUMPKIN), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
    }

    protected static void pancakeRecipes(@NotNull RecipeOutput recipeOutput, @NotNull DeferredItem<Item> pancakeBlock, @NotNull DeferredItem<Item> singlePancake, Ingredient topping, Ingredient ingredient) {
        ModRecipeProvider.pancakeRecipes(recipeOutput, pancakeBlock, singlePancake, topping, ingredient, ingredient);
    }

    protected static void pancakeRecipes(@NotNull RecipeOutput recipeOutput, @NotNull DeferredItem<Item> pancakeBlock, @NotNull DeferredItem<Item> singlePancake, Ingredient topping, Ingredient ingredient, Ingredient ingredient2) {
        DeferredItem<Item> batter = ModItems.BATTER;
        Item servingItem = Items.BOWL;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, pancakeBlock, (int)1).pattern(" T ").pattern("XMX").pattern("YBY").define(Character.valueOf('T'), topping).define(Character.valueOf('X'), ingredient).define(Character.valueOf('Y'), ingredient2).define(Character.valueOf('M'), batter).define(Character.valueOf('B'), (ItemLike)servingItem).unlockedBy(ModRecipeProvider.getHasName(batter), ModRecipeProvider.has(batter)).save(recipeOutput);
        ModRecipeProvider.oneToOne(recipeOutput, RecipeCategory.MISC, pancakeBlock, (ItemLike)singlePancake.get(), PancakeBlock.MAX_SERVINGS);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, pancakeBlock).requires(singlePancake, PancakeBlock.MAX_SERVINGS.intValue()).requires((ItemLike)servingItem).unlockedBy(ModRecipeProvider.getHasName(singlePancake), ModRecipeProvider.has(singlePancake)).save(recipeOutput, ModRecipeProvider.getRecipeName(singlePancake, pancakeBlock));
    }

    protected static void oneToOne(RecipeOutput recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)count).requires(item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static String getRecipeName(ItemLike item, ItemLike result) {
        return "rusticpancakes:" + ModRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)item);
    }

    private static Ingredient vegetablesPatch() {
        return DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
    }
}

