/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.datagen.loot;

import com.phantomwing.rusticpancakes.block.ModBlocks;
import com.phantomwing.rusticpancakes.block.custom.PancakeBlock;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class BlockLootTables
extends BlockLootSubProvider {
    public BlockLootTables(HolderLookup.Provider lookupProvider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
    }

    protected void generate() {
        this.dropFoodBlock((Block)ModBlocks.PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.HONEY_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.CHOCOLATE_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.CHERRY_BLOSSOM_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.VEGETABLE_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.PUMPKIN_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(e -> (Block)e.value()).toList();
    }

    private void dropFoodBlock(Block block, IntegerProperty servings, ItemLike containerItem) {
        this.add(block, blockParam -> this.createFoodBlockDrops((Block)blockParam, servings, containerItem));
    }

    private LootTable.Builder createFoodBlockDrops(Block block, IntegerProperty servings, ItemLike containerItem) {
        LootItemBlockStatePropertyCondition.Builder noServingsTaken = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)servings, 0));
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)noServingsTaken).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().when(InvertedLootItemCondition.invert((LootItemCondition.Builder)noServingsTaken)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)containerItem))));
    }
}

