/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.item;

import com.google.common.collect.Sets;
import com.phantomwing.rusticpancakes.block.ModBlocks;
import com.phantomwing.rusticpancakes.food.FoodValues;
import com.phantomwing.rusticpancakes.item.custom.ConsumableItem;
import com.phantomwing.rusticpancakes.item.custom.DrinkableItem;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final int BOWL_STACK_SIZE = 16;
    public static final int BOTTLE_STACK_SIZE = 16;
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"rusticpancakes");
    public static LinkedHashSet<Supplier<Item>> CREATIVE_TAB_ITEMS = Sets.newLinkedHashSet();
    public static final DeferredItem<Item> SYRUP = ModItems.registerWithTab("syrup", () -> new DrinkableItem(ModItems.bottleItem().food(FoodValues.SYRUP), true));
    public static final DeferredItem<Item> BATTER = ModItems.registerWithTab("batter", () -> new Item(ModItems.bowlItem().food(FoodValues.BATTER)));
    public static final DeferredItem<Item> PANCAKES = ModItems.registerBlockWithTab(ModBlocks.PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> PANCAKE = ModItems.registerWithTab("pancake", () -> new Item(ModItems.baseItem().food(FoodValues.PANCAKE)));
    public static final DeferredItem<Item> HONEY_PANCAKES = ModItems.registerBlockWithTab(ModBlocks.HONEY_PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> HONEY_PANCAKE = ModItems.registerWithTab("honey_pancake", () -> new ConsumableItem(ModItems.baseItem().food(FoodValues.HONEY_PANCAKE), true));
    public static final DeferredItem<Item> CHOCOLATE_PANCAKES = ModItems.registerBlockWithTab(ModBlocks.CHOCOLATE_PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> CHOCOLATE_PANCAKE = ModItems.registerWithTab("chocolate_pancake", () -> new ConsumableItem(ModItems.baseItem().food(FoodValues.CHOCOLATE_PANCAKE), true));
    public static final DeferredItem<Item> CHERRY_BLOSSOM_PANCAKES = ModItems.registerBlockWithTab(ModBlocks.CHERRY_BLOSSOM_PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> CHERRY_BLOSSOM_PANCAKE = ModItems.registerWithTab("cherry_blossom_pancake", () -> new ConsumableItem(ModItems.baseItem().food(FoodValues.CHERRY_BLOSSOM_PANCAKE), true));
    public static final DeferredItem<Item> VEGETABLE_PANCAKES = ModItems.registerBlockWithTab(ModBlocks.VEGETABLE_PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> VEGETABLE_PANCAKE = ModItems.registerWithTab("vegetable_pancake", () -> new ConsumableItem(ModItems.baseItem().food(FoodValues.VEGETABLE_PANCAKE), true));
    public static final DeferredItem<Item> PUMPKIN_PANCAKES = ModItems.registerBlockWithTab(ModBlocks.PUMPKIN_PANCAKES, ModItems.bowlItem());
    public static final DeferredItem<Item> PUMPKIN_PANCAKE = ModItems.registerWithTab("pumpkin_pancake", () -> new ConsumableItem(ModItems.baseItem().food(FoodValues.PUMPKIN_PANCAKE), true));

    public static Item.Properties baseItem() {
        return new Item.Properties();
    }

    public static Item.Properties bottleItem() {
        return ModItems.baseItem().craftRemainder(Items.GLASS_BOTTLE).stacksTo(16);
    }

    public static Item.Properties bowlItem() {
        return ModItems.baseItem().craftRemainder(Items.BOWL).stacksTo(16);
    }

    public static DeferredItem<Item> registerWithTab(String name, Supplier<Item> supplier) {
        DeferredItem item = ITEMS.register(name, supplier);
        CREATIVE_TAB_ITEMS.add((Supplier<Item>)item);
        return item;
    }

    public static DeferredItem<Item> registerBlockWithTab(DeferredBlock<Block> block, Item.Properties properties) {
        return ModItems.registerWithTab(block.getRegisteredName().replaceFirst("rusticpancakes:", ""), () -> new BlockItem((Block)block.get(), properties));
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

