/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticpancakes.item.custom;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class ConsumableItem
extends Item {
    private static final MutableComponent NO_EFFECTS = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);
    private final boolean hasFoodEffectTooltip;

    public ConsumableItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = false;
    }

    public ConsumableItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.getFoodProperties(consumer) != null) {
            super.finishUsingItem(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        if (stack.isEmpty()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).getAbilities().instabuild && !player.getInventory().add(containerStack)) {
                player.drop(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (this.hasFoodEffectTooltip) {
            Objects.requireNonNull(tooltip);
            this.addFoodEffectTooltip(stack, tooltip::add, 1.0f, context.tickRate());
        }
    }

    public void addFoodEffectTooltip(ItemStack stack, Consumer<Component> tooltipAdder, float durationFactor, float tickRate) {
        FoodProperties foodStats = stack.getFoodProperties((LivingEntity)null);
        if (foodStats != null) {
            List effectList = foodStats.effects();
            ArrayList attributeList = Lists.newArrayList();
            if (effectList.isEmpty()) {
                tooltipAdder.accept((Component)NO_EFFECTS);
            } else {
                for (FoodProperties.PossibleEffect possibleEffect : effectList) {
                    MobEffectInstance instance = possibleEffect.effect();
                    MutableComponent mutableComponent = Component.translatable((String)instance.getDescriptionId());
                    MobEffect effect = (MobEffect)instance.getEffect().value();
                    effect.createModifiers(instance.getAmplifier(), (attributeHolder, attributeModifier) -> attributeList.add(new Pair(attributeHolder, attributeModifier)));
                    if (instance.getAmplifier() > 0) {
                        mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
                    }
                    if (instance.getDuration() > 20) {
                        mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)durationFactor, (float)tickRate)});
                    }
                    tooltipAdder.accept((Component)mutableComponent.withStyle(effect.getCategory().getTooltipFormatting()));
                }
            }
            if (!attributeList.isEmpty()) {
                tooltipAdder.accept(CommonComponents.EMPTY);
                tooltipAdder.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
                for (Pair pair : attributeList) {
                    AttributeModifier attributemodifier = (AttributeModifier)pair.getSecond();
                    double amount = attributemodifier.amount();
                    double formattedAmount = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributemodifier.amount() : attributemodifier.amount() * 100.0;
                    if (amount > 0.0) {
                        tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(amount < 0.0)) continue;
                    tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

