/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core.world.inventory;

import java.util.List;
import neoforge.com.cursee.disenchanting_table.core.registry.ModMenus;
import neoforge.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DisenchantingTableMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData containerData;
    private final List<Integer> inputSlotIndexes = List.of(Integer.valueOf(0), Integer.valueOf(1));

    public DisenchantingTableMenu(int containerID, Inventory inventory) {
        this(containerID, inventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(1));
    }

    public DisenchantingTableMenu(int containerID, Inventory inventory, Container container, ContainerData containerData) {
        super(ModMenus.DISENCHANTING_TABLE, containerID);
        DisenchantingTableMenu.checkContainerSize((Container)container, (int)3);
        DisenchantingTableMenu.checkContainerDataCount((ContainerData)containerData, (int)1);
        this.container = container;
        this.containerData = containerData;
        this.addSlot(new Slot(this, container, 0, 27, 47){

            public boolean mayPlace(ItemStack stack) {
                return DisenchantmentHelper.canDisenchant(stack);
            }
        });
        this.addSlot(new Slot(this, container, 1, 76, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.BOOK);
            }
        });
        this.addSlot(new Slot(container, 2, 134, 47));
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)inventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)inventory, column, 8 + column * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int k;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int i = this.getInventorySlotStart();
            int j = this.getUseRowEnd();
            if (index == this.getResultSlot()) {
                if (!this.moveItemStackTo(itemstack1, i, j, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (this.inputSlotIndexes.contains(index) ? !this.moveItemStackTo(itemstack1, i, j, false) : (this.canMoveIntoInputSlots(itemstack1) && index >= this.getInventorySlotStart() && index < this.getUseRowEnd() ? !this.moveItemStackTo(itemstack1, k = this.getSlotToQuickMoveTo(itemstack), this.getResultSlot(), false) : (index >= this.getInventorySlotStart() && index < this.getInventorySlotEnd() ? !this.moveItemStackTo(itemstack1, this.getUseRowStart(), this.getUseRowEnd(), false) : index >= this.getUseRowStart() && index < this.getUseRowEnd() && !this.moveItemStackTo(itemstack1, this.getInventorySlotStart(), this.getInventorySlotEnd(), false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean canMoveIntoInputSlots(ItemStack stack) {
        return DisenchantmentHelper.canDisenchant(stack) || stack.is(Items.BOOK);
    }

    public int getSlotToQuickMoveTo(ItemStack stack) {
        if (stack.is(Items.BOOK)) {
            return 1;
        }
        return this.container.isEmpty() ? 0 : this.inputSlotIndexes.get(0);
    }

    public int getResultSlot() {
        return 2;
    }

    private int getInventorySlotStart() {
        return this.getResultSlot() + 1;
    }

    private int getInventorySlotEnd() {
        return this.getInventorySlotStart() + 27;
    }

    private int getUseRowStart() {
        return this.getInventorySlotEnd();
    }

    private int getUseRowEnd() {
        return this.getUseRowStart() + 9;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

