/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFItems;

public class FieryBlock
extends Block {
    public FieryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public boolean skipRendering(BlockState state, BlockState otherState, Direction direction) {
        return ModList.get().isLoaded("ctm") && otherState.getBlock() instanceof FieryBlock;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity living;
        if (!entity.fireImmune() && entity instanceof LivingEntity && !(living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).is((Item)TFItems.FIERY_BOOTS.get())) {
            entity.hurt(TFDamageTypes.getDamageSource(level, TFDamageTypes.FIERY, new EntityType[0]), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return true;
    }
}

