/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFParticleType;

public interface LightableBlock {
    public static final EnumProperty<Lighting> LIGHTING = EnumProperty.create((String)"lighting", Lighting.class);

    default public ItemInteractionResult tryLightCandles(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player) {
        if (stack.isEmpty() && player.getAbilities().mayBuild && state.getValue(LIGHTING) != Lighting.NONE) {
            this.extinguish(player, state, (LevelAccessor)level, pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (this.canBeLit(state) && stack.canPerformAction(ItemAbilities.FIRESTARTER_LIGHT)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void lightCandlesWithProjectile(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        if (!level.isClientSide() && projectile.isOnFire() && this.canBeLit(state)) {
            this.setLit((LevelAccessor)level, state, result.getBlockPos(), true);
        }
    }

    default public boolean canBeLit(BlockState state) {
        return state.getValue(LIGHTING) == Lighting.NONE;
    }

    public Iterable<Vec3> getParticleOffsets(BlockState var1, LevelAccessor var2, BlockPos var3);

    default public void addParticlesAndSound(Level level, BlockPos pos, double xFraction, double yFraction, double zFraction, RandomSource rand, Lighting lighting) {
        this.addParticlesAndSound(level, (double)pos.getX() + xFraction, (double)pos.getY() + yFraction, (double)pos.getZ() + zFraction, rand, lighting);
    }

    default public void addParticlesAndSound(Level level, double x, double y, double z, RandomSource rand, Lighting lighting) {
        float var3 = rand.nextFloat();
        if (var3 < 0.3f) {
            if (lighting == Lighting.NORMAL) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            if (var3 < 0.17f) {
                level.playLocalSound(x + 0.5, y + 0.5, z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        SimpleParticleType particle = switch (lighting.ordinal()) {
            default -> ParticleTypes.SMALL_FLAME;
            case 2 -> (SimpleParticleType)TFParticleType.DIM_FLAME.get();
            case 3 -> (SimpleParticleType)TFParticleType.OMINOUS_FLAME.get();
        };
        level.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
    }

    default public void extinguish(@Nullable Player player, BlockState state, LevelAccessor accessor, BlockPos pos) {
        this.setLit(accessor, state, pos, false);
        Block block = state.getBlock();
        if (block instanceof LightableBlock) {
            LightableBlock lightableBlock = (LightableBlock)block;
            lightableBlock.getParticleOffsets(state, accessor, pos).forEach(vec3 -> accessor.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + vec3.x, (double)pos.getY() + vec3.y, (double)pos.getZ() + vec3.z, 0.0, 0.025, 0.0));
        }
        accessor.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        accessor.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    default public void setLit(LevelAccessor accessor, BlockState state, BlockPos pos, boolean lit) {
        accessor.setBlock(pos, (BlockState)state.setValue(LIGHTING, (Comparable)((Object)(lit ? Lighting.NORMAL : Lighting.NONE))), 11);
    }

    public static enum Lighting implements StringRepresentable
    {
        NONE,
        NORMAL,
        DIM,
        OMINOUS;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

