/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.Hydra;

public class HydraRenderer<T extends Hydra, M extends HierarchicalModel<T>>
extends MobRenderer<T, M> {
    public static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraRenderer(EntityRendererProvider.Context context, M model, float shadowSize) {
        super(context, model, shadowSize);
    }

    protected float getFlipDegrees(Hydra entity) {
        return 0.0f;
    }

    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float yaw, float partialTicks, float scale) {
        if (this.isShaking((LivingEntity)entity)) {
            yaw += (float)(Math.cos((double)((Hydra)entity).tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if (!entity.hasPose(Pose.SLEEPING)) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        }
        if (((Hydra)entity).deathTime > 0) {
            float f = ((float)((Hydra)entity).deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((Hydra)entity)));
        } else if (HydraRenderer.isEntityUpsideDown(entity)) {
            stack.translate(0.0f, 6.0f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

