/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;
import twilightforest.beanification.Component;
import twilightforest.world.components.structures.util.StructureHints;

@Component
public class GenerateBookCommand {
    private final SimpleCommandExceptionType ERROR_NOT_RUN_BY_PLAYER = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.not_player"));

    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"genbook").executes(context -> this.generateBook((CommandSourceStack)context.getSource(), null))).requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"structure", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE)).executes(context -> this.generateBook((CommandSourceStack)context.getSource(), (Holder.Reference<Structure>)ResourceKeyArgument.getStructure((CommandContext)context, (String)"structure"))));
    }

    private int generateBook(CommandSourceStack source, @Nullable Holder.Reference<Structure> structureKey) throws CommandSyntaxException {
        Player player;
        Entity entity = source.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity) instanceof FakePlayer) {
            throw this.ERROR_NOT_RUN_BY_PLAYER.create();
        }
        if (structureKey == null) {
            for (Structure structure : source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE).stream().toList()) {
                StructureHints hint;
                if (!(structure instanceof StructureHints) || player.addItem((hint = (StructureHints)structure).createHintBook(source.registryAccess()))) continue;
                player.drop(hint.createHintBook(source.registryAccess()), true);
            }
        } else {
            Object structure = source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE).get(structureKey.key());
            if (structure instanceof StructureHints) {
                StructureHints hint = (StructureHints)structure;
                if (!player.addItem(hint.createHintBook(source.registryAccess()))) {
                    player.drop(hint.createHintBook(source.registryAccess()), true);
                }
            } else {
                ItemStack book = StructureHints.HintConfig.defaultBook();
                if (!player.addItem(book)) {
                    player.drop(book, true);
                }
            }
        }
        return 1;
    }
}

