/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.monster.LichMinion;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class LichMinionsGoal
extends Goal {
    public static final float ATTACK_RANGE = 20.0f;
    private final Lich lich;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime;

    public LichMinionsGoal(Lich boss) {
        this.lich = boss;
        this.strafingTime = -1;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.lich.getPhase() == 2 && !this.lich.isShadowClone();
    }

    public void start() {
        this.lich.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.ZOMBIE_SCEPTER.get()));
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
    }

    public void tick() {
        boolean hasLineOfSight;
        if (this.lich.getTeleportInvisibility() > 0) {
            return;
        }
        LivingEntity targetedEntity = this.lich.getTarget();
        if (targetedEntity == null) {
            return;
        }
        float dist = this.lich.distanceTo((Entity)targetedEntity);
        if (this.lich.getAttackCooldown() % 15 == 0) {
            this.checkAndSpawnMinions();
        }
        if ((hasLineOfSight = this.lich.getSensing().hasLineOfSight((Entity)targetedEntity)) != this.seeTime > 0) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        if (dist < 20.0f && this.seeTime >= 20) {
            this.lich.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.lich.getRandom().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.lich.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if ((double)dist > 15.0) {
                this.strafingBackwards = false;
            } else if ((double)dist < 5.0) {
                this.strafingBackwards = true;
            }
            this.lich.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.lich.lookAt((Entity)targetedEntity, 30.0f, 30.0f);
        } else {
            this.lich.getLookControl().setLookAt((Entity)targetedEntity, 30.0f, 30.0f);
        }
        if (this.lich.getAttackCooldown() == 0) {
            if (dist < 2.0f) {
                this.lich.doHurtTarget((Entity)targetedEntity);
                this.lich.swing(InteractionHand.MAIN_HAND);
                this.lich.setAttackCooldown(20);
            } else if (dist < 20.0f && this.lich.getSensing().hasLineOfSight((Entity)targetedEntity)) {
                if (this.lich.getNextAttackType() == 0) {
                    this.lich.launchProjectileAt(new LichBolt(this.lich.level(), (LivingEntity)this.lich));
                } else {
                    this.lich.launchProjectileAt(new LichBomb(this.lich.level(), (LivingEntity)this.lich));
                }
                this.lich.swing(InteractionHand.MAIN_HAND);
                this.lich.setNextAttackType(this.lich.getRandom().nextBoolean() ? 0 : 1);
                this.lich.setAttackCooldown(60);
            } else {
                this.lich.teleportToNewTarget(targetedEntity, 20.0f, null);
                this.lich.setAttackCooldown(20);
            }
        }
    }

    private void checkAndSpawnMinions() {
        int minions;
        if (!this.lich.level().isClientSide() && this.lich.getMinionsToSummon() > 0 && (minions = this.lich.countMyMinions()) < 3) {
            this.spawnMinionAt();
            this.lich.setMinionsToSummon(this.lich.getMinionsToSummon() - 1);
        }
    }

    private void spawnMinionAt() {
        Level level;
        LivingEntity targetedEntity = this.lich.getTarget();
        Vec3 minionSpot = this.lich.findVecInLOSOf((Entity)targetedEntity);
        if (minionSpot != null && (level = this.lich.level()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            LichMinion minion = new LichMinion(this.lich.level(), this.lich);
            minion.setPos(minionSpot.x(), minionSpot.y(), minionSpot.z());
            EventHooks.finalizeMobSpawn((Mob)minion, (ServerLevelAccessor)accessor, (DifficultyInstance)this.lich.level().getCurrentDifficultyAt(BlockPos.containing((Position)minionSpot)), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null);
            this.lich.level().addFreshEntity((Entity)minion);
            minion.setTarget(targetedEntity);
            minion.spawnAnim();
            minion.playSound((SoundEvent)TFSounds.MINION_SUMMON.get(), 1.0f, ((this.lich.getRandom().nextFloat() - this.lich.getRandom().nextFloat()) * 0.7f + 1.0f) * 0.75f);
            this.lich.swing(InteractionHand.MAIN_HAND);
            this.lich.makeMagicTrail(this.lich.getEyePosition(), minion.getEyePosition(), this.lich.getRandom().nextFloat() * 0.0625f + 0.125f, this.lich.getRandom().nextFloat() * 0.0625f + 0.125f, this.lich.getRandom().nextFloat() * 0.0625f + 0.125f);
        }
    }
}

