/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive.quest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.entity.passive.quest.ram.QuestingRamContext;
import twilightforest.entity.passive.quest.ram.QuestingRamCurrentContext;

public class QuestReloadListener
extends SimpleJsonResourceReloadListener {
    @Autowired
    private static QuestingRamCurrentContext questingRamCurrentContext;
    private static final Gson GSON;

    public QuestReloadListener() {
        super(GSON, "twilight/quests");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        boolean found = false;
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            if (!entry.getKey().getPath().equals("questing_ram")) continue;
            questingRamCurrentContext.setContext((QuestingRamContext)QuestingRamContext.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(JsonParseException::new));
            TwilightForestMod.LOGGER.debug("Questing Ram quest set by mod {}", (Object)entry.getKey().getNamespace());
            found = true;
        }
        if (!found) {
            TwilightForestMod.LOGGER.error("Questing Ram quest file not found. Defaulting to fallback");
            questingRamCurrentContext.setContext(QuestingRamContext.FALLBACK);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }
}

