/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.components.entity.TFPortalAttachment;
import twilightforest.components.entity.YetiThrowAttachment;
import twilightforest.config.TFConfig;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDimension;
import twilightforest.network.UpdateShieldPacket;
import twilightforest.world.NoReturnTeleporter;
import twilightforest.world.TFTeleporter;

@EventBusSubscriber(modid="twilightforest")
public class CapabilityEvents {
    @SubscribeEvent
    public static void updateShields(EntityTickEvent.Post event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living.hasData(TFDataAttachments.FORTIFICATION_SHIELDS)) {
            ((FortificationShieldAttachment)event.getEntity().getData(TFDataAttachments.FORTIFICATION_SHIELDS)).tick(living);
        }
    }

    @SubscribeEvent
    public static void updatePlayerCaps(PlayerTickEvent.Post event) {
        if (((Boolean)event.getEntity().getData(TFDataAttachments.FEATHER_FAN)).booleanValue()) {
            event.getEntity().setIgnoreFallDamageFromCurrentImpulse(true);
            event.getEntity().currentImpulseImpactPos = event.getEntity().position();
            if (event.getEntity().onGround() || event.getEntity().isSwimming() || event.getEntity().isInWater()) {
                event.getEntity().setData(TFDataAttachments.FEATHER_FAN, (Object)false);
            }
        }
        ((YetiThrowAttachment)event.getEntity().getData(TFDataAttachments.YETI_THROWING)).tick(event.getEntity());
        ((TFPortalAttachment)event.getEntity().getData(TFDataAttachments.TF_PORTAL_COOLDOWN)).tick(event.getEntity());
    }

    @SubscribeEvent
    public static void livingAttack(LivingIncomingDamageEvent event) {
        FortificationShieldAttachment attachment;
        LivingEntity living = event.getEntity();
        if (!living.level().isClientSide() && !event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && (attachment = (FortificationShieldAttachment)living.getData(TFDataAttachments.FORTIFICATION_SHIELDS)).shieldsLeft() > 0) {
            if (living.invulnerableTime <= 0) {
                attachment.breakShield(living, false);
                FortificationShieldAttachment.addShieldBreakParticles(event.getSource(), living);
                Objects.requireNonNull(living);
                living.invulnerableTime = 20;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.getRespawnPosition() == null) {
            CapabilityEvents.newSpawnInTwilightForest(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (event.getEntity().level().isClientSide() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CapabilityEvents.updateCapabilities(player2, (Entity)event.getEntity());
        CapabilityEvents.dataFixLegacyBanish(player2);
        if (!player2.hasData(TFDataAttachments.BANISHED_TO_TWILIGHT_FOREST)) {
            CapabilityEvents.newSpawnInTwilightForest(player2);
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CapabilityEvents.updateCapabilities(player2, (Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        CapabilityEvents.updateCapabilities((ServerPlayer)event.getEntity(), event.getTarget());
    }

    private static void updateCapabilities(ServerPlayer clientTarget, Entity shielded) {
        FortificationShieldAttachment attachment = (FortificationShieldAttachment)shielded.getData(TFDataAttachments.FORTIFICATION_SHIELDS);
        if (attachment.shieldsLeft() > 0) {
            PacketDistributor.sendToPlayer((ServerPlayer)clientTarget, (CustomPacketPayload)new UpdateShieldPacket(shielded.getId(), attachment.temporaryShieldsLeft(), attachment.permanentShieldsLeft()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void newSpawnInTwilightForest(ServerPlayer player) {
        if (!TFConfig.newPlayersSpawnInTF) {
            return;
        }
        ServerLevel level = player.getServer().getLevel(TFDimension.DIMENSION_KEY);
        if (level == null) {
            return;
        }
        BlockPos newDefaultSpawn = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, player.blockPosition());
        player.changeDimension(TFConfig.portalForNewPlayerSpawn ? TFTeleporter.createTransition((Entity)player, level, newDefaultSpawn, true) : NoReturnTeleporter.createNoPortalTransition(level, (Entity)player, newDefaultSpawn));
        player.setRespawnPosition(TFDimension.DIMENSION_KEY, newDefaultSpawn, player.getYRot(), true, false);
        player.setData(TFDataAttachments.BANISHED_TO_TWILIGHT_FOREST, (Object)Unit.INSTANCE);
    }

    private static void dataFixLegacyBanish(ServerPlayer player) {
        CompoundTag tagCompound = player.getPersistentData();
        if (!tagCompound.contains("PlayerPersisted")) {
            return;
        }
        CompoundTag playerData = tagCompound.getCompound("PlayerPersisted");
        if (!playerData.contains("twilightforest_banished")) {
            return;
        }
        playerData.remove("twilightforest_banished");
        tagCompound.put("PlayerPersisted", (Tag)playerData);
        if (player.hasData(TFDataAttachments.BANISHED_TO_TWILIGHT_FOREST)) {
            return;
        }
        player.setData(TFDataAttachments.BANISHED_TO_TWILIGHT_FOREST, (Object)Unit.INSTANCE);
    }
}

