/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.enums.extensions.TFDamageEffectsEnumExtension;
import twilightforest.util.entities.EntityExcludedDamageSource;

public class TFDamageTypes {
    @Autowired
    private static TFDamageEffectsEnumExtension tfDamageEffectsEnumExtension;
    public static final ResourceKey<DamageType> GHAST_TEAR;
    public static final ResourceKey<DamageType> HYDRA_BITE;
    public static final ResourceKey<DamageType> HYDRA_FIRE;
    public static final ResourceKey<DamageType> HYDRA_MORTAR;
    public static final ResourceKey<DamageType> LICH_BOLT;
    public static final ResourceKey<DamageType> LICH_BOMB;
    public static final ResourceKey<DamageType> CHILLING_BREATH;
    public static final ResourceKey<DamageType> SQUISH;
    public static final ResourceKey<DamageType> THROWN_AXE;
    public static final ResourceKey<DamageType> THROWN_PICKAXE;
    public static final ResourceKey<DamageType> THORNS;
    public static final ResourceKey<DamageType> KNIGHTMETAL;
    public static final ResourceKey<DamageType> FIERY;
    public static final ResourceKey<DamageType> FIRE_JET;
    public static final ResourceKey<DamageType> REACTOR;
    public static final ResourceKey<DamageType> SLIDER;
    public static final ResourceKey<DamageType> THROWN_BLOCK;
    public static final ResourceKey<DamageType> AXING;
    public static final ResourceKey<DamageType> SLAM;
    public static final ResourceKey<DamageType> YEETED;
    public static final ResourceKey<DamageType> ANT;
    public static final ResourceKey<DamageType> HAUNT;
    public static final ResourceKey<DamageType> CLAMPED;
    public static final ResourceKey<DamageType> SCORCHED;
    public static final ResourceKey<DamageType> FROZEN;
    public static final ResourceKey<DamageType> SPIKED;
    public static final ResourceKey<DamageType> LEAF_BRAIN;
    public static final ResourceKey<DamageType> LOST_WORDS;
    public static final ResourceKey<DamageType> SCHOOLED;
    public static final ResourceKey<DamageType> SNOWBALL_FIGHT;
    public static final ResourceKey<DamageType> TWILIGHT_SCEPTER;
    public static final ResourceKey<DamageType> LIFEDRAIN;
    public static final ResourceKey<DamageType> EXPIRED;
    public static final ResourceKey<DamageType> FALLING_ICE;
    public static final ResourceKey<DamageType> MOONWORM;
    public static final ResourceKey<DamageType> ACID_RAIN;
    public static final ResourceKey<DamageType> OMINOUS_FIRE;
    public static final ResourceKey<DamageType> FAILED_CHALLENGE;

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type, EntityType<?> ... toIgnore) {
        return TFDamageTypes.getEntityDamageSource(level, type, null, toIgnore);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, EntityType<?> ... toIgnore) {
        return TFDamageTypes.getIndirectEntityDamageSource(level, type, attacker, attacker, toIgnore);
    }

    public static DamageSource getIndirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker, EntityType<?> ... toIgnore) {
        return toIgnore.length > 0 ? new EntityExcludedDamageSource((Holder<DamageType>)level.registryAccess().holderOrThrow(type), attacker, indirectAttacker, toIgnore) : new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), attacker, indirectAttacker);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(GHAST_TEAR, (Object)new DamageType("twilightforest.ghastTear", 0.0f));
        context.register(HYDRA_BITE, (Object)new DamageType("twilightforest.hydraBite", 0.0f));
        context.register(HYDRA_FIRE, (Object)new DamageType("twilightforest.hydraFire", 0.0f));
        context.register(HYDRA_MORTAR, (Object)new DamageType("onFire", 0.0f, DamageEffects.BURNING));
        context.register(LICH_BOLT, (Object)new DamageType("twilightforest.lichBolt", 0.0f));
        context.register(LICH_BOMB, (Object)new DamageType("twilightforest.lichBomb", 0.0f));
        context.register(CHILLING_BREATH, (Object)new DamageType("twilightforest.chillingBreath", 0.0f, DamageEffects.FREEZING));
        context.register(SQUISH, (Object)new DamageType("twilightforest.squish", 0.0f));
        context.register(THROWN_AXE, (Object)new DamageType("twilightforest.thrownAxe", 0.0f));
        context.register(THROWN_PICKAXE, (Object)new DamageType("twilightforest.thrownPickaxe", 0.0f));
        context.register(THORNS, (Object)new DamageType("twilightforest.thorns", 0.1f));
        context.register(KNIGHTMETAL, (Object)new DamageType("twilightforest.knightmetal", 0.1f));
        context.register(FIERY, (Object)new DamageType("twilightforest.fiery", 0.1f, DamageEffects.BURNING));
        context.register(FIRE_JET, (Object)new DamageType("twilightforest.fireJet", 0.1f, DamageEffects.BURNING));
        context.register(REACTOR, (Object)new DamageType("twilightforest.reactor", 0.1f));
        context.register(SLIDER, (Object)new DamageType("twilightforest.slider", 0.1f));
        context.register(THROWN_BLOCK, (Object)new DamageType("twilightforest.thrownBlock", 0.1f));
        context.register(AXING, (Object)new DamageType("twilightforest.axing", 0.1f));
        context.register(SLAM, (Object)new DamageType("twilightforest.axing", 0.1f));
        context.register(YEETED, (Object)new DamageType("twilightforest.yeeted", 0.1f));
        context.register(ANT, (Object)new DamageType("twilightforest.ant", 0.1f));
        context.register(HAUNT, (Object)new DamageType("twilightforest.haunt", 0.1f));
        context.register(CLAMPED, (Object)new DamageType("twilightforest.clamped", 0.1f, TFDamageTypes.tfDamageEffectsEnumExtension.PINCH));
        context.register(SCORCHED, (Object)new DamageType("twilightforest.scorched", 0.1f, DamageEffects.BURNING));
        context.register(FROZEN, (Object)new DamageType("twilightforest.frozen", 0.1f, DamageEffects.FREEZING));
        context.register(SPIKED, (Object)new DamageType("twilightforest.spiked", 0.1f));
        context.register(LEAF_BRAIN, (Object)new DamageType("twilightforest.leafBrain", 0.1f));
        context.register(LOST_WORDS, (Object)new DamageType("twilightforest.lostWords", 0.1f));
        context.register(SCHOOLED, (Object)new DamageType("twilightforest.schooled", 0.1f));
        context.register(SNOWBALL_FIGHT, (Object)new DamageType("twilightforest.snowballFight", 0.1f, DamageEffects.FREEZING));
        context.register(TWILIGHT_SCEPTER, (Object)new DamageType("indirectMagic", 0.0f));
        context.register(LIFEDRAIN, (Object)new DamageType("twilightforest.lifedrain", 0.0f));
        context.register(EXPIRED, (Object)new DamageType("twilightforest.expired", 0.0f));
        context.register(FALLING_ICE, (Object)new DamageType("fallingBlock", 0.1f));
        context.register(MOONWORM, (Object)new DamageType("twilightforest.moonworm", 0.0f));
        context.register(ACID_RAIN, (Object)new DamageType("twilightforest.acid_rain", 0.0f));
        context.register(OMINOUS_FIRE, (Object)new DamageType("twilightforest.ominous", 0.1f, DamageEffects.BURNING));
        context.register(FAILED_CHALLENGE, (Object)new DamageType("twilightforest.failedChallenge", 0.0f));
    }

    static {
        GHAST_TEAR = TFDamageTypes.create("ghast_tear");
        HYDRA_BITE = TFDamageTypes.create("hydra_bite");
        HYDRA_FIRE = TFDamageTypes.create("hydra_fire");
        HYDRA_MORTAR = TFDamageTypes.create("hydra_mortar");
        LICH_BOLT = TFDamageTypes.create("lich_bolt");
        LICH_BOMB = TFDamageTypes.create("lich_bomb");
        CHILLING_BREATH = TFDamageTypes.create("chilling_breath");
        SQUISH = TFDamageTypes.create("squish");
        THROWN_AXE = TFDamageTypes.create("thrown_axe");
        THROWN_PICKAXE = TFDamageTypes.create("thrown_pickaxe");
        THORNS = TFDamageTypes.create("thorns");
        KNIGHTMETAL = TFDamageTypes.create("knightmetal");
        FIERY = TFDamageTypes.create("fiery");
        FIRE_JET = TFDamageTypes.create("fire_jet");
        REACTOR = TFDamageTypes.create("reactor");
        SLIDER = TFDamageTypes.create("slider");
        THROWN_BLOCK = TFDamageTypes.create("thrown_block");
        AXING = TFDamageTypes.create("axing");
        SLAM = TFDamageTypes.create("slam");
        YEETED = TFDamageTypes.create("yeeted");
        ANT = TFDamageTypes.create("ant");
        HAUNT = TFDamageTypes.create("haunt");
        CLAMPED = TFDamageTypes.create("clamped");
        SCORCHED = TFDamageTypes.create("scorched");
        FROZEN = TFDamageTypes.create("frozen");
        SPIKED = TFDamageTypes.create("spiked");
        LEAF_BRAIN = TFDamageTypes.create("leaf_brain");
        LOST_WORDS = TFDamageTypes.create("lost_words");
        SCHOOLED = TFDamageTypes.create("schooled");
        SNOWBALL_FIGHT = TFDamageTypes.create("snowball_fight");
        TWILIGHT_SCEPTER = TFDamageTypes.create("twilight_scepter");
        LIFEDRAIN = TFDamageTypes.create("lifedrain");
        EXPIRED = TFDamageTypes.create("expired");
        FALLING_ICE = TFDamageTypes.create("falling_ice");
        MOONWORM = TFDamageTypes.create("moonworm");
        ACID_RAIN = TFDamageTypes.create("acid_rain");
        OMINOUS_FIRE = TFDamageTypes.create("ominous_fire");
        FAILED_CHALLENGE = TFDamageTypes.create("failed_challenge");
    }
}

