/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.item.MagicMapItem;

public class EmptyMagicMapItem
extends ComplexItem {
    public EmptyMagicMapItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack emptyMapStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.pass((Object)emptyMapStack);
        }
        if (!level.dimensionTypeRegistration().is(CustomTagGenerator.DimensionTypeTagGenerator.ALLOWS_MAGIC_MAP_CHARTING)) {
            player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.magic_map_fail"), true);
            return InteractionResultHolder.fail((Object)emptyMapStack);
        }
        emptyMapStack.consume(1, (LivingEntity)player);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.level().playSound(null, (Entity)player, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, player.getSoundSource(), 1.0f, 1.0f);
        ItemStack newMapStack = MagicMapItem.setupNewMap(level, Mth.floor((double)player.getX()), Mth.floor((double)player.getZ()), (byte)4, true, false);
        if (emptyMapStack.isEmpty()) {
            return InteractionResultHolder.success((Object)newMapStack);
        }
        if (!player.getInventory().add(newMapStack.copy())) {
            player.drop(newMapStack, false);
        }
        return InteractionResultHolder.success((Object)emptyMapStack);
    }
}

