/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.entities;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.init.TFSounds;

public class EntityUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method LivingEntity_getDeathSound = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"getDeathSound", (Class[])new Class[0]);
    private static final MethodHandle handle_LivingEntity_getDeathSound;
    private static final Method HangingEntity_setDirection;
    private static final MethodHandle handle_HangingEntity_setDirection;

    public static <T extends Mob> BlockPos bossChestLocation(T boss) {
        return !((EnforcedHomePoint)boss).isRestrictionPointValid((ResourceKey<Level>)boss.level().dimension()) ? boss.blockPosition() : ((EnforcedHomePoint)boss).getRestrictionPoint().pos().below();
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.getBlockState(pos), entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, BlockState state, Entity entity) {
        float hardness = state.getDestroySpeed((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.isAir() && !(world.getBlockEntity(pos) instanceof Container) && state.getBlock().canEntityDestroy(state, (BlockGetter)world, pos, entity) && (!(entity instanceof LivingEntity) || EventHooks.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static BlockHitResult rayTrace(Entity entity, double range) {
        Vec3 position = entity.getEyePosition(1.0f);
        Vec3 look = entity.getViewVector(1.0f);
        Vec3 dest = position.add(look.x * range, look.y * range, look.z * range);
        return entity.level().clip(new ClipContext(position, dest, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }

    public static BlockHitResult rayTrace(Player player) {
        return EntityUtil.rayTrace(player, null);
    }

    public static BlockHitResult rayTrace(Player player, @Nullable DoubleUnaryOperator modifier) {
        double range = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        return EntityUtil.rayTrace((Entity)player, modifier == null ? range : modifier.applyAsDouble(range));
    }

    @Nullable
    public static SoundEvent getDeathSound(LivingEntity living) {
        SoundEvent sound = null;
        if (handle_LivingEntity_getDeathSound != null) {
            try {
                sound = handle_LivingEntity_getDeathSound.invokeExact(living);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sound;
    }

    public static void killLavaAround(Entity entity) {
        AABB bounds = entity.getBoundingBox().inflate(9.0);
        for (double x = bounds.minX; x < bounds.maxX; x += 1.0) {
            for (double z = bounds.minZ; z < bounds.maxZ; z += 1.0) {
                for (double y = bounds.minY; y < bounds.maxY; y += 1.0) {
                    BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                    BlockState state = entity.level().getBlockState(pos);
                    if (!state.is(Blocks.LAVA)) continue;
                    entity.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }

    public static boolean properlyApplyCustomDamageSource(Mob entity, Entity victim, DamageSource source, @Nullable SoundEvent flingSound) {
        boolean flag;
        float f = (float)entity.getAttributeValue(Attributes.ATTACK_DAMAGE);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)entity.getWeaponItem(), (Entity)entity, (DamageSource)source, (float)f);
        }
        if (flag = victim.hurt(source, f)) {
            Level level2;
            float f1 = EntityUtil.getKnockback(entity, victim, source);
            if (f1 > 0.0f && victim instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)victim;
                if (flingSound != null) {
                    entity.playSound(flingSound, 1.0f, 1.0f);
                }
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180)))));
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = entity.level()) instanceof ServerLevel) {
                ServerLevel level3 = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)level3, (Entity)victim, (DamageSource)source);
            }
            entity.setLastHurtMob((Entity)entity);
        }
        return flag;
    }

    protected static float getKnockback(Mob entity, Entity victim, DamageSource source) {
        float f;
        float f2 = (float)entity.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)entity.getWeaponItem(), (Entity)victim, (DamageSource)source, (float)f2);
        } else {
            f = f2;
        }
        return f;
    }

    @Nullable
    private static <T extends Entity> T createEntityIgnoreException(EntityType<T> type, ServerLevelAccessor levelAccessor) {
        try {
            return (T)type.create((Level)levelAccessor.getLevel());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean tryHangPainting(WorldGenLevel world, BlockPos pos, Direction direction, @Nullable Holder<PaintingVariant> chosenPainting) {
        if (chosenPainting == null) {
            return false;
        }
        Painting painting = (Painting)EntityUtil.createEntityIgnoreException(EntityType.PAINTING, (ServerLevelAccessor)world);
        painting.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        try {
            handle_HangingEntity_setDirection.invoke(painting, direction);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        painting.setVariant(chosenPainting);
        if (EntityUtil.checkValidPaintingPosition(world, painting)) {
            world.addFreshEntity((Entity)painting);
            return true;
        }
        return false;
    }

    @Nullable
    public static Holder<PaintingVariant> getPaintingOfSize(WorldGenLevel level, RandomSource rand, int minSize) {
        return EntityUtil.getPaintingOfSize(level, rand, minSize, minSize, false);
    }

    @Nullable
    public static Holder<PaintingVariant> getPaintingOfSize(WorldGenLevel level, RandomSource rand, int width, int height, boolean exactMeasurements) {
        ArrayList<Holder> valid = new ArrayList<Holder>();
        for (Holder art : level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).holders().toList()) {
            if (exactMeasurements) {
                if (((PaintingVariant)art.value()).width() != width || ((PaintingVariant)art.value()).height() != height) continue;
                valid.add(art);
                continue;
            }
            if (((PaintingVariant)art.value()).width() < width && ((PaintingVariant)art.value()).height() < height) continue;
            valid.add(art);
        }
        if (!valid.isEmpty()) {
            return (Holder)valid.get(rand.nextInt(valid.size()));
        }
        return null;
    }

    public static List<Holder<PaintingVariant>> getPaintingsOfSizeOrSmaller(WorldGenLevel level, TagKey<PaintingVariant> lichTowerPaintings, int width, int height) {
        ArrayList<Holder<PaintingVariant>> valid = new ArrayList<Holder<PaintingVariant>>();
        for (Holder art : level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(lichTowerPaintings)) {
            if (((PaintingVariant)art.value()).width() > width || ((PaintingVariant)art.value()).height() > height) continue;
            valid.add((Holder<PaintingVariant>)art);
        }
        return valid;
    }

    public static boolean checkValidPaintingPosition(WorldGenLevel world, @Nullable Painting painting) {
        if (painting == null) {
            return false;
        }
        AABB largerBox = painting.getBoundingBox();
        if (!world.noCollision((Entity)painting, largerBox)) {
            return false;
        }
        List<Entity> collidingEntities = EntityUtil.getEntitiesInAABB(world, largerBox);
        for (Entity entityOnList : collidingEntities) {
            if (!(entityOnList instanceof HangingEntity)) continue;
            return false;
        }
        return true;
    }

    public static List<Entity> getEntitiesInAABB(WorldGenLevel world, AABB boundingBox) {
        ArrayList list = Lists.newArrayList();
        int i = Mth.floor((double)((boundingBox.minX - 2.0) / 16.0));
        int j = Mth.floor((double)((boundingBox.maxX + 2.0) / 16.0));
        int k = Mth.floor((double)((boundingBox.minZ - 2.0) / 16.0));
        int l = Mth.floor((double)((boundingBox.maxZ + 2.0) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                ChunkAccess chunk = world.getChunk(i1, j1, ChunkStatus.STRUCTURE_STARTS);
                if (!(chunk instanceof ProtoChunk)) continue;
                ProtoChunk proto = (ProtoChunk)chunk;
                proto.getEntities().forEach(nbt -> {
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world.getLevel(), e -> e);
                    if (entity != null && boundingBox.intersects(entity.getBoundingBox())) {
                        list.add(entity);
                    }
                });
            }
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean convertEntity(LivingEntity oldEntity, EntityType<?> newType) {
        block16: {
            var3_2 = oldEntity.level();
            if (!(var3_2 instanceof ServerLevel)) {
                return false;
            }
            level = (ServerLevel)var3_2;
            newEntity = newType.create((Level)level);
            if (newEntity == null) {
                return false;
            }
            if (newEntity instanceof LivingEntity && !EventHooks.canLivingConvert((LivingEntity)oldEntity, (EntityType)(living = (LivingEntity)newEntity).getType(), (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$convertEntity$2(java.lang.Integer ), (Ljava/lang/Integer;)V)())) break block16;
            passengerSave = oldEntity.getPassengers();
            if (!(oldEntity instanceof Mob)) ** GOTO lbl-1000
            mob = (Mob)oldEntity;
            if (newEntity instanceof Mob) {
                newMob = (Mob)newEntity;
                newEntity = mob.convertTo(newMob.getType(), true);
            } else lbl-1000:
            // 2 sources

            {
                newEntity.copyPosition((Entity)oldEntity);
                if (newEntity instanceof Mob) {
                    mob = (Mob)newEntity;
                    if (oldEntity instanceof Mob) {
                        oldMob = (Mob)oldEntity;
                        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                            itemstack = oldEntity.getItemBySlot(equipmentslot).copyAndClear();
                            if (itemstack.isEmpty()) continue;
                            mob.setItemSlot(equipmentslot, itemstack.copyAndClear());
                            mob.setDropChance(equipmentslot, oldMob.getEquipmentDropChance(equipmentslot));
                        }
                    }
                    EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(oldEntity.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, null);
                }
                oldEntity.level().addFreshEntity(newEntity);
                oldEntity.discard();
            }
            try {
                uuid = newEntity.getUUID();
                newEntity.load(oldEntity.saveWithoutId(newEntity.saveWithoutId(new CompoundTag())));
                newEntity.setUUID(uuid);
                if (newEntity instanceof LivingEntity) {
                    living = (EquipmentSlot[])newEntity;
                    living.setHealth(living.getMaxHealth());
                }
            }
            catch (Exception e) {
                TwilightForestMod.LOGGER.warn("Couldn't transform entity NBT data", (Throwable)e);
            }
            if (oldEntity instanceof Saddleable && (saddleable = (Saddleable)oldEntity).isSaddled() && !(newEntity instanceof Saddleable)) {
                newEntity.spawnAtLocation((ItemLike)Items.SADDLE);
            }
            if (newEntity instanceof Mob) {
                mob = (Mob)newEntity;
                mob.spawnAnim();
                mob.spawnAnim();
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    itemstack = mob.getItemBySlot(equipmentslot).copyAndClear();
                    mob.spawnAtLocation(itemstack);
                }
            }
            if (!passengerSave.isEmpty()) {
                for (Entity entity : passengerSave) {
                    entity.startRiding(newEntity, true);
                }
            }
            if (newEntity instanceof LivingEntity) {
                living = (LivingEntity)newEntity;
                EventHooks.onLivingConvert((LivingEntity)oldEntity, (LivingEntity)living);
            }
            level.playSound(null, newEntity.blockPosition(), (SoundEvent)TFSounds.POWDER_USE.get(), newEntity.getSoundSource());
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends Entity> T createEntityIgnoreException(ServerLevelAccessor level, EntityType<T> type) {
        try {
            return (T)type.create((Level)level.getLevel());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$convertEntity$2(Integer timer) {
    }

    static {
        HangingEntity_setDirection = ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"setDirection", (Class[])new Class[]{Direction.class});
        MethodHandle tmp_handle_LivingEntity_getDeathSound = null;
        MethodHandle tmp_handle_HangingEntity_setDirection = null;
        try {
            tmp_handle_LivingEntity_getDeathSound = LOOKUP.unreflect(LivingEntity_getDeathSound);
            tmp_handle_HangingEntity_setDirection = LOOKUP.unreflect(HangingEntity_setDirection);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        handle_LivingEntity_getDeathSound = tmp_handle_LivingEntity_getDeathSound;
        handle_HangingEntity_setDirection = tmp_handle_HangingEntity_setDirection;
    }
}

