/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.StructureTemplateDefinitions;
import twilightforest.world.components.structures.util.ProgressionPiece;

public class TwilightJigsawPiece
extends TwilightTemplateStructurePiece
implements ProgressionPiece,
PieceBeardifierModifier {
    private final JigsawRecord sourceJigsaw;
    private final List<JigsawRecord> spareJigsaws;
    private TerrainAdjustment terrainAdjustment;

    public static TwilightJigsawPiece defaultDeserialize(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        TwilightJigsawPiece twilightJigsawPiece = new TwilightJigsawPiece((StructurePieceType)TFStructurePieceTypes.TFJigsawTemplate.value(), compoundTag, ctx, TwilightJigsawPiece.readSettings(compoundTag));
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        return twilightJigsawPiece;
    }

    @Nullable
    public static TwilightJigsawPiece initializeTemplateFromPool(ResourceLocation templatePool, BlockPos.MutableBlockPos parentJunctionPos, FrontAndTop parentOrientation, String selectName, RandomSource rand, int genDepth, StructureTemplateManager structureManager) {
        ResourceLocation templateId = StructureTemplateDefinitions.getRandomTemplate(rand, templatePool);
        JigsawPlaceContext placeContext = JigsawPlaceContext.pickPlaceableJunction((BlockPos)parentJunctionPos, BlockPos.ZERO, parentOrientation, structureManager, templateId, selectName, rand);
        if (templateId == null || placeContext == null) {
            return null;
        }
        return TwilightJigsawPiece.defaultForTemplate(genDepth, structureManager, templateId, placeContext);
    }

    public static TwilightJigsawPiece defaultForTemplate(int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext) {
        TwilightJigsawPiece twilightJigsawPiece = new TwilightJigsawPiece((StructurePieceType)TFStructurePieceTypes.TFJigsawTemplate.value(), genDepth, structureManager, templateLocation, jigsawContext);
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        return twilightJigsawPiece;
    }

    public TwilightJigsawPiece(StructurePieceType structurePieceType, CompoundTag compoundTag, StructurePieceSerializationContext ctx, StructurePlaceSettings placeSettings) {
        super(structurePieceType, compoundTag, ctx, placeSettings);
        this.sourceJigsaw = TwilightJigsawPiece.readSourceFromNBT(compoundTag);
        this.spareJigsaws = TwilightJigsawPiece.readConnectionsFromNBT(compoundTag);
        this.terrainAdjustment = TerrainAdjustment.NONE;
    }

    public TwilightJigsawPiece(StructurePieceType type, int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext) {
        super(type, genDepth, structureManager, templateLocation, jigsawContext.placementSettings(), jigsawContext.templatePos());
        this.sourceJigsaw = jigsawContext.seedJigsaw();
        this.spareJigsaws = Collections.unmodifiableList(jigsawContext.spareJigsaws());
        this.terrainAdjustment = TerrainAdjustment.NONE;
    }

    protected static JigsawRecord readSourceFromNBT(CompoundTag structureTag) {
        return JigsawRecord.fromTag(structureTag.getCompound("source"));
    }

    protected static List<JigsawRecord> readConnectionsFromNBT(CompoundTag structureTag) {
        ListTag connections = structureTag.getList("connections", 10);
        ArrayList<JigsawRecord> connectionsList = new ArrayList<JigsawRecord>();
        for (Tag tagEntry : connections) {
            if (!(tagEntry instanceof CompoundTag)) continue;
            CompoundTag tag = (CompoundTag)tagEntry;
            connectionsList.add(JigsawRecord.fromTag(tag));
        }
        return Collections.unmodifiableList(connectionsList);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.put("source", (Tag)this.sourceJigsaw.toTag());
        ListTag tags = new ListTag();
        for (JigsawRecord record : this.spareJigsaws) {
            tags.add((Object)record.toTag());
        }
        structureTag.put("connections", (Tag)tags);
    }

    public void addChildren(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random) {
        super.addChildren(parent, pieceAccessor, random);
        List<JigsawRecord> jigsaws = this.spareJigsaws;
        for (int i = 0; i < jigsaws.size(); ++i) {
            this.processJigsaw(parent, pieceAccessor, random, jigsaws.get(i), i);
        }
    }

    protected void processJigsaw(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, int jigsawIndex) {
    }

    @Override
    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureCenterPos) {
        super.postProcess(level, structureManager, chunkGen, random, chunkBounds, chunkPos, structureCenterPos);
        ChunkAccess chunkAt = level.getChunk(chunkPos.getWorldPosition());
        for (StructureTemplate.StructureBlockInfo blockInfo : this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.JIGSAW)) {
            BlockPos infoPos = blockInfo.pos();
            if (!chunkBounds.isInside((Vec3i)infoPos)) continue;
            chunkAt.markPosForPostprocessing(infoPos);
        }
    }

    public JigsawRecord getSourceJigsaw() {
        return this.sourceJigsaw;
    }

    public BlockPos getSourcePosition() {
        return this.templatePosition.offset((Vec3i)this.sourceJigsaw.pos());
    }

    public List<JigsawRecord> getSpareJigsaws() {
        return this.spareJigsaws;
    }

    public List<JigsawRecord> matchSpareJigsaws(Predicate<JigsawRecord> filter) {
        ArrayList<JigsawRecord> jigsaws = new ArrayList<JigsawRecord>();
        for (JigsawRecord record : this.spareJigsaws) {
            if (!filter.test(record)) continue;
            jigsaws.add(record);
        }
        return jigsaws;
    }

    public int firstMatchIndex(Predicate<JigsawRecord> filter) {
        for (int i = 0; i < this.spareJigsaws.size(); ++i) {
            if (!filter.test(this.spareJigsaws.get(i))) continue;
            return i;
        }
        return -1;
    }

    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    public TerrainAdjustment getTerrainAdjustment() {
        return this.terrainAdjustment;
    }

    public int getGroundLevelDelta() {
        return 0;
    }
}

