/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

public class LandmarkGridPlacement
extends StructurePlacement {
    public static final MapCodec<LandmarkGridPlacement> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceKey.codec((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structure_grid_lock").forGetter(p -> p.landmark)).apply((Applicative)inst, LandmarkGridPlacement::new));
    private final Optional<ResourceKey<Structure>> landmark;

    public static LandmarkGridPlacement forceStructureForCenters() {
        return new LandmarkGridPlacement(Optional.empty());
    }

    public LandmarkGridPlacement(Optional<ResourceKey<Structure>> landmark) {
        super(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return this.landmark.isEmpty() || LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ) == this.landmark.get();
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)TFStructurePlacementTypes.GRID_LANDMARK_PLACEMENT_TYPE.get();
    }
}

