/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import quek.undergarden.registry.UGSoundEvents;

public abstract class VirulentMixFluid
extends BaseFlowingFluid {
    public VirulentMixFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    protected void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (random.nextInt(300) == 0) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)UGSoundEvents.VIRULENT_BUBBLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (!state.isSource() && random.nextInt(64) == 0) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)UGSoundEvents.VIRULENT_FLOW.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    public static class Source
    extends VirulentMixFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends VirulentMixFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

