/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.dweller.Dweller;

public class DwellerModel<T extends Dweller>
extends AgeableListModel<T> {
    private final ModelPart torso;
    private final ModelPart mane;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public DwellerModel(ModelPart root) {
        this.torso = root.getChild("torso");
        this.mane = this.torso.getChild("mane");
        this.head = root.getChild("head");
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
    }

    public static LayerDefinition createBodyLayer(float torsoInflate) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 23).addBox(-6.0f, -3.0f, -6.0f, 12.0f, 8.0f, 15.0f, new CubeDeformation(torsoInflate)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)3.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mane = torso.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(41, 10).addBox(-1.0f, -6.0f, -8.0f, 2.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.0f, -8.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(52, 57).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 46).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-2.0f));
        PartDefinition trunk = head.addOrReplaceChild("trunk", CubeListBuilder.create().texOffs(39, 26).addBox(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-1.0f, (float)2.618f, (float)0.0f, (float)0.0f));
        PartDefinition trunk2 = trunk.addOrReplaceChild("trunk2", CubeListBuilder.create().texOffs(39, 0).addBox(-1.0f, 0.0f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(52, 40).addBox(-4.0f, -2.0f, -3.0f, 4.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)5.0f, (float)6.0f));
        PartDefinition rightFoot = rightLeg.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(0, 60).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)9.0f, (float)3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(32, 46).addBox(0.0f, -2.0f, -3.0f, 4.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)5.0f, (float)6.0f));
        PartDefinition leftFoot = leftLeg.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(58, 0).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)9.0f, (float)3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = -1.3963f + headPitch * ((float)Math.PI / 180);
        this.leftLeg.xRot = -0.6109f + Mth.cos((float)(limbSwing * 0.6662f)) * 0.66f * limbSwingAmount;
        this.rightLeg.xRot = -0.6109f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.66f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.mane.visible = !((Dweller)((Object)entity)).isSaddled();
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
    }
}

