/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile.slingshot;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import quek.undergarden.block.GrongletBlock;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.registry.UGSoundEvents;

public abstract class AbstractGronglet
extends SlingshotProjectile {
    public AbstractGronglet(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public AbstractGronglet(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public AbstractGronglet(EntityType<? extends ThrowableItemProjectile> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    protected abstract GrongletBlock getGrongletBlock();

    protected Item getDefaultItem() {
        return this.getGrongletBlock().asItem();
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide() && this.ricochetTimes == 0) {
            BlockPos pos = result.getBlockPos();
            Direction direction = result.getDirection();
            if (((BlockState)this.getGrongletBlock().defaultBlockState().setValue((Property)GrongletBlock.FACING, (Comparable)direction)).canSurvive((LevelReader)this.level(), pos.relative(direction)) && this.level().getBlockState(pos.relative(direction)).isAir()) {
                this.level().setBlock(pos.relative(direction), (BlockState)this.getGrongletBlock().defaultBlockState().setValue((Property)GrongletBlock.FACING, (Comparable)direction), 2);
                this.level().playSound(null, pos, (SoundEvent)UGSoundEvents.GRONGLET_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.spawnAtLocation(new ItemStack((ItemLike)this.getDefaultItem()));
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Player player;
        Entity entity = result.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).hasItemInSlot(EquipmentSlot.HEAD)) {
            player.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)this.getDefaultItem()));
        } else {
            this.spawnAtLocation(new ItemStack((ItemLike)this.getDefaultItem()));
        }
        this.level().playSound(null, result.getEntity().blockPosition(), (SoundEvent)UGSoundEvents.GRONGLET_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.discard();
    }
}

