/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.recipe;

import java.util.Locale;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import quek.undergarden.recipe.InfusingBookCategory;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGRecipeTypes;
import quek.undergarden.registry.UGTags;

public interface InfusingRecipe
extends Recipe<SingleRecipeInput> {
    public SlotType getRecipeSlotType();

    public float experience();

    public int infusingTime();

    public InfusingBookCategory category();

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public ItemStack getToastSymbol() {
        return new ItemStack(UGBlocks.INFUSER);
    }

    default public RecipeType<?> getType() {
        return (RecipeType)UGRecipeTypes.INFUSING.get();
    }

    default public boolean isSpecial() {
        return true;
    }

    public static enum SlotType implements StringRepresentable
    {
        UTHERIUM(1, UGTags.Items.INFUSER_UTHERIUM_FUELS),
        ROGDORIUM(2, UGTags.Items.INFUSER_ROGDORIUM_FUELS);

        public static final StringRepresentable.EnumCodec<SlotType> CODEC;
        private final int slotIndex;
        private final TagKey<Item> validItems;

        private SlotType(int slotIndex, TagKey<Item> validItems) {
            this.slotIndex = slotIndex;
            this.validItems = validItems;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public TagKey<Item> getValidItems() {
            return this.validItems;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(SlotType::values);
        }
    }
}

