/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import quek.undergarden.registry.UGTags;

public class UGBlockBlobFeature
extends Feature<BlockStateConfiguration> {
    public UGBlockBlobFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockState blockstate;
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockStateConfiguration blockstateconfiguration = (BlockStateConfiguration)context.config();
        while (pos.getY() > level.getMinBuildHeight() + 6 && (level.isEmptyBlock(pos.below()) || !UGBlockBlobFeature.isDirt((BlockState)(blockstate = level.getBlockState(pos.below()))) && !blockstate.is(UGTags.Blocks.BASE_STONE_UNDERGARDEN))) {
            pos = pos.below();
        }
        if (pos.getY() <= level.getMinBuildHeight() + 6 || pos.getY() >= 110) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int x = random.nextInt(5);
            int y = random.nextInt(5);
            int z = random.nextInt(5);
            float f = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)pos.offset(-x, -y, -z), (BlockPos)pos.offset(x, y, z))) {
                if (!(blockpos1.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                level.setBlock(blockpos1, blockstateconfiguration.state, 3);
            }
            pos = pos.offset(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        return true;
    }
}

