/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.datagen;

import com.phantomwing.rusticdelight.datagen.ModBiomeTagsProvider;
import com.phantomwing.rusticdelight.datagen.ModBlockStateProvider;
import com.phantomwing.rusticdelight.datagen.ModBlockTagsProvider;
import com.phantomwing.rusticdelight.datagen.ModDataMapProvider;
import com.phantomwing.rusticdelight.datagen.ModGlobalLootModifiersProvider;
import com.phantomwing.rusticdelight.datagen.ModItemModelProvider;
import com.phantomwing.rusticdelight.datagen.ModItemTagsProvider;
import com.phantomwing.rusticdelight.datagen.ModLootTableProvider;
import com.phantomwing.rusticdelight.datagen.ModRecipeProvider;
import com.phantomwing.rusticdelight.world.ModBiomeModifiers;
import com.phantomwing.rusticdelight.world.ModConfiguredFeatures;
import com.phantomwing.rusticdelight.world.ModPlacedFeatures;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="rusticdelight")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(output, lookupProvider, existingFileHelper));
        RegistrySetBuilder registrySetBuilder = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModConfiguredFeatures::bootstrap).add(Registries.PLACED_FEATURE, ModPlacedFeatures::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ModBiomeModifiers::bootstrap);
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        ModBlockTagsProvider blockTagsProvider = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, registrySetBuilder, Set.of("rusticdelight")));
    }
}

