/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.datagen;

import com.phantomwing.rusticdelight.block.custom.PancakeBlock;
import com.phantomwing.rusticdelight.item.ModItems;
import com.phantomwing.rusticdelight.tags.CommonTags;
import com.phantomwing.rusticdelight.tags.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class ModRecipeProvider
extends RecipeProvider {
    public static final float FOOD_COOKING_EXP = 0.35f;

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        this.buildCraftingRecipes(output);
        this.buildCuttingRecipes(output);
        this.buildCookingRecipes(output);
        this.buildFarmersDelightOverrideRecipes(output);
    }

    private void buildCraftingRecipes(@NotNull RecipeOutput output) {
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_GREEN, ModItems.ROASTED_BELL_PEPPER_GREEN, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_YELLOW, ModItems.ROASTED_BELL_PEPPER_YELLOW, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_RED, ModItems.ROASTED_BELL_PEPPER_RED, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_SLICE_GREEN, ModItems.ROASTED_BELL_PEPPER_SLICE_GREEN, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_SLICE_YELLOW, ModItems.ROASTED_BELL_PEPPER_SLICE_YELLOW, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.BELL_PEPPER_SLICE_RED, ModItems.ROASTED_BELL_PEPPER_SLICE_RED, 0.35f);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.BELL_PEPPER_SOUP, (int)1).requires((ItemLike)Items.BOWL).requires(CommonTags.FOODS_BELL_PEPPER).requires(CommonTags.FOODS_BELL_PEPPER).requires(CommonTags.FOODS_BELL_PEPPER).requires(CommonTags.FOODS_BELL_PEPPER).requires(CommonTags.FOODS_BELL_PEPPER).requires(CommonTags.FOODS_BELL_PEPPER).unlockedBy(ModRecipeProvider.getHasName(ModItems.BELL_PEPPER_RED), ModRecipeProvider.has(ModItems.BELL_PEPPER_RED)).unlockedBy(ModRecipeProvider.getHasName(ModItems.BELL_PEPPER_GREEN), ModRecipeProvider.has(ModItems.BELL_PEPPER_GREEN)).unlockedBy(ModRecipeProvider.getHasName(ModItems.BELL_PEPPER_YELLOW), ModRecipeProvider.has(ModItems.BELL_PEPPER_YELLOW)).save(output);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.CALAMARI, ModItems.COOKED_CALAMARI, 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.CALAMARI_SLICE, ModItems.COOKED_CALAMARI_SLICE, 0.35f);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_SLICE_GREEN, ModItems.BELL_PEPPER_ROLL_GREEN);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_SLICE_YELLOW, ModItems.BELL_PEPPER_ROLL_YELLOW);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_SLICE_RED, ModItems.BELL_PEPPER_ROLL_RED);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.CALAMARI_ROLL, (int)2).requires(ModTags.Items.CALAMARI_ROLL_INGREDIENTS).requires(ModTags.Items.CALAMARI_ROLL_INGREDIENTS).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).unlockedBy(ModRecipeProvider.getHasName(ModItems.CALAMARI_SLICE), ModRecipeProvider.has(ModItems.CALAMARI_SLICE)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.CHERRY_BLOSSOM_ROLL, (int)2).requires(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).requires(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PINK_PETALS), ModRecipeProvider.has((ItemLike)Items.PINK_PETALS)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CHERRY_SAPLING), ModRecipeProvider.has((ItemLike)Items.CHERRY_SAPLING)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CHERRY_LEAVES), ModRecipeProvider.has((ItemLike)Items.CHERRY_LEAVES)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).save(output);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.POTATO_SLICES, ModItems.BAKED_POTATO_SLICES, 0.35f);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.POTATO_SALAD, (int)1).requires((ItemLike)Items.BOWL).requires(CommonTags.FOODS_POTATO).requires(CommonTags.FOODS_ONION).requires(CommonTags.FOODS_MILK).requires(Tags.Items.EGGS).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.POTATO), ModRecipeProvider.has((ItemLike)Items.POTATO)).unlockedBy(ModRecipeProvider.getHasName(ModItems.POTATO_SLICES), ModRecipeProvider.has(ModItems.POTATO_SLICES)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SWEET_SALAD, (int)1).requires((ItemLike)Items.BOWL).requires(ModTags.Items.SWEET_LIQUIDS).requires(CommonTags.FOODS_LEAFY_GREEN).requires(Tags.Items.FOODS_VEGETABLE).requires(Tags.Items.FOODS_FRUIT).requires(Tags.Items.FOODS_FRUIT).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.HONEY_BOTTLE), ModRecipeProvider.has((ItemLike)Items.HONEY_BOTTLE)).unlockedBy(ModRecipeProvider.getHasName(ModItems.SYRUP), ModRecipeProvider.has(ModItems.SYRUP)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.CHERRY_BLOSSOM_COOKIE, (int)8).requires(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PINK_PETALS), ModRecipeProvider.has((ItemLike)Items.PINK_PETALS)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CHERRY_SAPLING), ModRecipeProvider.has((ItemLike)Items.CHERRY_SAPLING)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CHERRY_LEAVES), ModRecipeProvider.has((ItemLike)Items.CHERRY_LEAVES)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.COFFEE_COOKIE, (int)8).requires(ModTags.Items.COFFEE_INGREDIENTS).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ModRecipeProvider.getHasName(ModItems.ROASTED_COFFEE_BEANS), ModRecipeProvider.has(ModItems.ROASTED_COFFEE_BEANS)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SYRUP_COOKIE, (int)8).requires(ModTags.Items.SYRUP).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ModRecipeProvider.getHasName(ModItems.SYRUP), ModRecipeProvider.has(ModItems.SYRUP)).save(output);
        ModRecipeProvider.pieRecipes(output, ModItems.SYRUP_CHEESECAKE, ModItems.SYRUP_CHEESECAKE_SLICE, Ingredient.of(ModTags.Items.SYRUP));
        ModRecipeProvider.pieRecipes(output, ModItems.CHERRY_BLOSSOM_CHEESECAKE, ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE, Ingredient.of(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.PANCAKES, ModItems.PANCAKE, Ingredient.of(ModTags.Items.SYRUP), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.HONEY_PANCAKES, ModItems.HONEY_PANCAKE, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHOCOLATE_PANCAKES, ModItems.CHOCOLATE_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.VEGETABLE_PANCAKES, ModItems.VEGETABLE_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), ModRecipeProvider.vegetablesPatch(), Ingredient.of(CommonTags.FOODS_LEAFY_GREEN));
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHERRY_BLOSSOM_PANCAKES, ModItems.CHERRY_BLOSSOM_PANCAKE, Ingredient.of(CommonTags.FOODS_MILK), Ingredient.of(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.PUMPKIN_PANCAKES, ModItems.PUMPKIN_PANCAKE, Ingredient.of(ModTags.Items.SYRUP), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PUMPKIN_SLICE.get()}));
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.COTTON_BOLL, (ItemLike)Items.STRING, 1);
        ModRecipeProvider.horizontalRecipe(output, RecipeCategory.MISC, ModItems.COTTON_BOLL, (ItemLike)Items.PAPER, 3);
        ModRecipeProvider.twoBytwo(output, RecipeCategory.MISC, ModItems.COTTON_BOLL, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.CANVAS.get(), 1);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.COTTON_SEEDS, ModItems.COTTON_SEEDS_BAG);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.COTTON_BOLL, ModItems.COTTON_BOLL_CRATE);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_GREEN, (ItemLike)Items.GREEN_DYE, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_YELLOW, (ItemLike)Items.YELLOW_DYE, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_RED, (ItemLike)Items.RED_DYE, 1);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_SEEDS, ModItems.BELL_PEPPER_SEEDS_BAG);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_GREEN, ModItems.BELL_PEPPER_GREEN_CRATE);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_YELLOW, ModItems.BELL_PEPPER_YELLOW_CRATE);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.BELL_PEPPER_RED, ModItems.BELL_PEPPER_RED_CRATE);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.COFFEE_BEANS, ModItems.COFFEE_BEANS_BAG);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, ModItems.ROASTED_COFFEE_BEANS, ModItems.ROASTED_COFFEE_BEANS_BAG);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.COFFEE_BEANS, (ItemLike)Items.YELLOW_DYE, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.ROASTED_COFFEE_BEANS, (ItemLike)Items.BROWN_DYE, 1);
        ModRecipeProvider.foodCookingRecipes(output, ModItems.COFFEE_BEANS, ModItems.ROASTED_COFFEE_BEANS, 0.35f);
        Ingredient goldenCoffeeBeansIngredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COFFEE_BEANS.get(), (ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, ModItems.GOLDEN_COFFEE_BEANS, (int)1).pattern("GGG").pattern("GCG").pattern("GGG").define(Character.valueOf('G'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('C'), goldenCoffeeBeansIngredient).unlockedBy(ModRecipeProvider.getHasName(ModItems.COFFEE_BEANS), ModRecipeProvider.has(ModItems.COFFEE_BEANS)).unlockedBy(ModRecipeProvider.getHasName(ModItems.ROASTED_COFFEE_BEANS), ModRecipeProvider.has(ModItems.ROASTED_COFFEE_BEANS)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.MILK_COFFEE, (int)1).requires(ModItems.COFFEE).requires(CommonTags.FOODS_MILK).unlockedBy(ModRecipeProvider.getHasName(ModItems.COFFEE), ModRecipeProvider.has(ModItems.COFFEE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.CHOCOLATE_COFFEE, (int)1).requires(ModItems.MILK_COFFEE).requires((ItemLike)Items.COCOA_BEANS).requires((ItemLike)Items.COCOA_BEANS).unlockedBy(ModRecipeProvider.getHasName(ModItems.MILK_COFFEE), ModRecipeProvider.has(ModItems.MILK_COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.MILK_COFFEE, ModItems.CHOCOLATE_COFFEE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.CHOCOLATE_COFFEE, (int)1).requires(ModItems.COFFEE).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.COCOA_BEANS).requires((ItemLike)Items.COCOA_BEANS).unlockedBy(ModRecipeProvider.getHasName(ModItems.COFFEE), ModRecipeProvider.has(ModItems.COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.COFFEE, ModItems.CHOCOLATE_COFFEE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.HONEY_COFFEE, (int)1).requires(ModItems.MILK_COFFEE).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy(ModRecipeProvider.getHasName(ModItems.MILK_COFFEE), ModRecipeProvider.has(ModItems.MILK_COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.MILK_COFFEE, ModItems.HONEY_COFFEE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.HONEY_COFFEE, (int)1).requires(ModItems.COFFEE).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy(ModRecipeProvider.getHasName(ModItems.COFFEE), ModRecipeProvider.has(ModItems.COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.COFFEE, ModItems.HONEY_COFFEE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SYRUP_COFFEE, (int)1).requires(ModItems.MILK_COFFEE).requires(ModTags.Items.SYRUP).unlockedBy(ModRecipeProvider.getHasName(ModItems.MILK_COFFEE), ModRecipeProvider.has(ModItems.MILK_COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.MILK_COFFEE, ModItems.SYRUP_COFFEE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SYRUP_COFFEE, (int)1).requires(ModItems.COFFEE).requires(CommonTags.FOODS_MILK).requires(ModTags.Items.SYRUP).unlockedBy(ModRecipeProvider.getHasName(ModItems.COFFEE), ModRecipeProvider.has(ModItems.COFFEE)).save(output, ModRecipeProvider.getRecipeName(ModItems.COFFEE, ModItems.SYRUP_COFFEE));
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, ModItems.SYRUP, (ItemLike)Items.SUGAR, 3);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.SYRUP_SANDWICH, (int)1).requires(Tags.Items.FOODS_BREAD).requires(ModTags.Items.SYRUP).requires((ItemLike)Items.SUGAR).unlockedBy(ModRecipeProvider.getHasName(ModItems.SYRUP), ModRecipeProvider.has(ModItems.SYRUP)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ModItems.RICE_ROLL_ROYALE).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).requires((ItemLike)ModItems.BELL_PEPPER_ROLL_GREEN.get()).requires((ItemLike)ModItems.BELL_PEPPER_ROLL_YELLOW.get()).requires((ItemLike)ModItems.BELL_PEPPER_ROLL_RED.get()).requires((ItemLike)ModItems.CALAMARI_ROLL.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)ModItems.CHERRY_BLOSSOM_ROLL.get()).unlockedBy("has_rice_roll", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_ROLL_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_ROLL_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_ROLL_RED.get(), (ItemLike)ModItems.CALAMARI_ROLL.get(), (ItemLike)ModItems.CHERRY_BLOSSOM_ROLL.get(), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()})).save(output);
    }

    private void buildCuttingRecipes(@NotNull RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.WILD_COTTON}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.COTTON_SEEDS, (int)1).addResultWithChance(ModItems.COTTON_BOLL, 0.3f).addResultWithChance((ItemLike)Items.WHITE_DYE, 0.1f).build(output, ModItems.WILD_COTTON.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.WILD_BELL_PEPPERS}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.BELL_PEPPER_SEEDS, (int)1).addResultWithChance(ModItems.BELL_PEPPER_RED, 0.3f).addResultWithChance((ItemLike)Items.RED_DYE, 0.1f).build(output, ModItems.WILD_BELL_PEPPERS.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.BELL_PEPPER_GREEN}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.BELL_PEPPER_SLICE_GREEN, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.BELL_PEPPER_GREEN.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.BELL_PEPPER_YELLOW}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.BELL_PEPPER_SLICE_YELLOW, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.BELL_PEPPER_YELLOW.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.BELL_PEPPER_RED}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.BELL_PEPPER_SLICE_RED, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.BELL_PEPPER_RED.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ROASTED_BELL_PEPPER_GREEN}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.ROASTED_BELL_PEPPER_SLICE_GREEN, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.ROASTED_BELL_PEPPER_GREEN.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ROASTED_BELL_PEPPER_YELLOW}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.ROASTED_BELL_PEPPER_SLICE_YELLOW, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.ROASTED_BELL_PEPPER_YELLOW.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ROASTED_BELL_PEPPER_RED}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.ROASTED_BELL_PEPPER_SLICE_RED, (int)1).addResultWithChance(ModItems.BELL_PEPPER_SEEDS, 0.3f).build(output, ModItems.ROASTED_BELL_PEPPER_RED.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.WILD_COFFEE}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.COFFEE_BEANS, (int)1).addResultWithChance(ModItems.COFFEE_BEANS, 0.3f).addResultWithChance((ItemLike)Items.YELLOW_DYE, 0.1f).build(output, ModItems.WILD_COFFEE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.POTATO_SLICES, (int)2).build(output, ModItems.POTATO_SLICES.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAKED_POTATO}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.BAKED_POTATO_SLICES, (int)2).build(output, ModItems.BAKED_POTATO_SLICES.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.CALAMARI}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.CALAMARI_SLICE, (int)2).addResult((ItemLike)Items.BONE_MEAL).build(output, ModItems.CALAMARI_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.COOKED_CALAMARI}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.COOKED_CALAMARI_SLICE, (int)2).addResult((ItemLike)Items.BONE_MEAL).build(output, ModItems.COOKED_CALAMARI_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.CHERRY_BLOSSOM_CHEESECAKE}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE, (int)4).build(output, ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.SYRUP_CHEESECAKE}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), ModItems.SYRUP_CHEESECAKE_SLICE, (int)4).build(output, ModItems.SYRUP_CHEESECAKE_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)ItemTags.WOOL), (Ingredient)Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.STRING, (int)2).build(output, ResourceLocation.fromNamespaceAndPath((String)"rusticdelight", (String)"wool"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)ItemTags.WOOL_CARPETS), (Ingredient)Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.STRING, (int)1).build(output, ResourceLocation.fromNamespaceAndPath((String)"rusticdelight", (String)"wool_carpet"));
    }

    private void buildCookingRecipes(@NotNull RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.COOKING_OIL, (int)2, (int)100, (float)0.35f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.COTTON_SEEDS, Items.PUMPKIN_SEEDS}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.COOKING_OIL.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.BATTER, (int)2, (int)100, (float)0.35f, (ItemLike)Items.BOWL).addIngredient(CommonTags.FOODS_MILK).addIngredient(Tags.Items.EGGS).addIngredient((ItemLike)Items.WHEAT).addIngredient((ItemLike)Items.WHEAT).unlockedByAnyIngredient(new ItemLike[]{Items.MILK_BUCKET, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.BATTER.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.SYRUP, (int)1, (int)100, (float)0.35f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(ModTags.Items.SYRUP_INGREDIENTS).addIngredient((ItemLike)Items.SUGAR).unlockedByAnyIngredient(new ItemLike[]{Items.APPLE, Items.BEETROOT, Items.SUGAR}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.SYRUP.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRIED_DOUGH, (int)1, (int)100, (float)0.35f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(CommonTags.FOODS_DOUGH).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.FRIED_DOUGH.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRIED_DUMPLINGS, (int)2, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.DUMPLINGS.get(), 2).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.DUMPLINGS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.FRIED_DUMPLINGS.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.SPRING_ROLLS, (int)2, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(CommonTags.FOODS_DOUGH).addIngredient(CommonTags.FOODS_LEAFY_GREEN).addIngredient(ModTags.Items.SPRING_ROLL_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.SPRING_ROLLS.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRUIT_BEIGNET, (int)1, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(CommonTags.FOODS_DOUGH).addIngredient(Tags.Items.FOODS_FRUIT).addIngredient((ItemLike)Items.SUGAR).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModItems.FRUIT_BEIGNET.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRIED_CALAMARI, (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(ModItems.BATTER).addIngredient(CommonTags.FOODS_RAW_CALAMARI).addIngredient(CommonTags.FOODS_TOMATO).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.FRIED_CALAMARI.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRIED_CHICKEN, (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(ModItems.BATTER).addIngredient(CommonTags.FOODS_RAW_CHICKEN).addIngredient(CommonTags.FOODS_ONION).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.FRIED_CHICKEN.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.FRIED_MUSHROOMS, (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.RED_MUSHROOM).addIngredient(CommonTags.FOODS_ONION).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.FRIED_MUSHROOMS.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.BELL_PEPPER_SOUP, (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(CommonTags.FOODS_BELL_PEPPER).addIngredient(CommonTags.FOODS_BELL_PEPPER).addIngredient(CommonTags.FOODS_BELL_PEPPER).unlockedByAnyIngredient(new ItemLike[]{ModItems.BELL_PEPPER_GREEN, ModItems.BELL_PEPPER_YELLOW, ModItems.BELL_PEPPER_RED}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.BELL_PEPPER_SOUP.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.STUFFED_BELL_PEPPER_GREEN, (int)1, (int)200, (float)1.0f).addIngredient(ModItems.BELL_PEPPER_GREEN).addIngredient(CommonTags.CROPS_RICE).addIngredient(ModTags.Items.STUFFED_BELL_PEPPER_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.BELL_PEPPER_GREEN}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.STUFFED_BELL_PEPPER_GREEN.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.STUFFED_BELL_PEPPER_YELLOW, (int)1, (int)200, (float)1.0f).addIngredient(ModItems.BELL_PEPPER_YELLOW).addIngredient(CommonTags.CROPS_RICE).addIngredient(ModTags.Items.STUFFED_BELL_PEPPER_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.BELL_PEPPER_YELLOW}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.STUFFED_BELL_PEPPER_YELLOW.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.STUFFED_BELL_PEPPER_RED, (int)1, (int)200, (float)1.0f).addIngredient(ModItems.BELL_PEPPER_RED).addIngredient(CommonTags.CROPS_RICE).addIngredient(ModTags.Items.STUFFED_BELL_PEPPER_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.BELL_PEPPER_RED}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.STUFFED_BELL_PEPPER_RED.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.BELL_PEPPER_PASTA, (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(CommonTags.FOODS_PASTA).addIngredient(CommonTags.FOODS_BELL_PEPPER).addIngredient(CommonTags.FOODS_BELL_PEPPER).addIngredient(CommonTags.FOODS_BELL_PEPPER).unlockedByAnyIngredient(new ItemLike[]{ModItems.BELL_PEPPER_GREEN, ModItems.BELL_PEPPER_YELLOW, ModItems.BELL_PEPPER_RED}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.BELL_PEPPER_PASTA.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.COFFEE, (int)1, (int)200, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.MILK_COFFEE, (int)1, (int)200, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(CommonTags.FOODS_MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.MILK_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.CHOCOLATE_COFFEE, (int)1, (int)200, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(CommonTags.FOODS_MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient((ItemLike)Items.COCOA_BEANS, 2).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.CHOCOLATE_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.HONEY_COFFEE, (int)1, (int)200, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(CommonTags.FOODS_MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient((ItemLike)Items.HONEY_BOTTLE, 1).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.HONEY_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.SYRUP_COFFEE, (int)1, (int)200, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(CommonTags.FOODS_MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModItems.SYRUP, 1).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.SYRUP_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.DARK_COFFEE, (int)1, (int)400, (float)1.0f, (ItemLike)Items.GLASS_BOTTLE).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{ModItems.ROASTED_COFFEE_BEANS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output, ModItems.DARK_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe(ModItems.COFFEE_BRAISED_BEEF, (int)1, (int)400, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(CommonTags.FOODS_RAW_BEEF).addIngredient(ModTags.Items.COFFEE_FOOD_INGREDIENTS).addIngredient(CommonTags.FOODS_CARROT).addIngredient(CommonTags.FOODS_POTATO).unlockedByAnyIngredient(new ItemLike[]{ModItems.COFFEE}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output, ModItems.COFFEE_BRAISED_BEEF.getId());
    }

    private void buildFarmersDelightOverrideRecipes(@NotNull RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_RICE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.RICE.get()).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ModTags.Items.COOKING_OIL)})).addIngredient(CommonTags.FOODS_CARROT).addIngredient(CommonTags.FOODS_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.RICE.get(), Items.EGG, Items.CARROT, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.ONION.get(), ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_EGG.get()), (int)1, (int)100, (float)0.35f).addIngredient((ItemLike)Items.EGG).addIngredient(ModTags.Items.COOKING_OIL).unlockedByAnyIngredient(new ItemLike[]{ModItems.COOKING_OIL}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output, ModRecipeProvider.getRecipeName(ModItems.COOKING_OIL, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_EGG.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.BAKED_COD_STEW.get()), (int)1, (int)200, (float)1.0f).addIngredient(CommonTags.FOODS_RAW_COD).addIngredient(CommonTags.FOODS_POTATO).addIngredient(ModTags.Items.RAW_AND_COOKED_EGGS).addIngredient(CommonTags.FOODS_TOMATO).unlockedByAnyIngredient(new ItemLike[]{Items.COD, Items.POTATO, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.TOMATO.get(), Items.EGG}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.BEEF_STEW.get()), (int)1, (int)200, (float)1.0f).addIngredient(CommonTags.FOODS_RAW_BEEF).addIngredient(CommonTags.FOODS_CARROT).addIngredient(CommonTags.FOODS_POTATO).unlockedByAnyIngredient(new ItemLike[]{Items.BEEF, Items.CARROT, Items.POTATO}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.MUSHROOM_RICE.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.RED_MUSHROOM).addIngredient(CommonTags.CROPS_RICE).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(CommonTags.FOODS_CARROT), Ingredient.of(CommonTags.FOODS_POTATO)})).unlockedByAnyIngredient(new ItemLike[]{Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.RICE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.VEGETABLE_SOUP.get()), (int)1, (int)200, (float)1.0f).addIngredient(CommonTags.FOODS_CARROT).addIngredient(CommonTags.FOODS_POTATO).addIngredient(CommonTags.FOODS_BEETROOT).addIngredient(CommonTags.FOODS_LEAFY_GREEN).unlockedByAnyIngredient(new ItemLike[]{Items.CARROT, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.ONION.get(), Items.BEETROOT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
    }

    protected static void oneToOne(RecipeOutput recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)count).requires(item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void horizontalRecipe(RecipeOutput recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)count).pattern("###").define(Character.valueOf('#'), item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void twoBytwo(RecipeOutput recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)count).pattern("##").pattern("##").define(Character.valueOf('#'), item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void storageItemRecipes(RecipeOutput recipeOutput, RecipeCategory category, ItemLike item, ItemLike storageItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)storageItem).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.getRecipeName(item, storageItem));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)item, (int)9).requires(storageItem).unlockedBy(ModRecipeProvider.getHasName((ItemLike)storageItem), ModRecipeProvider.has((ItemLike)storageItem)).save(recipeOutput, ModRecipeProvider.getRecipeName(storageItem, item));
    }

    protected static void foodCookingRecipes(@NotNull RecipeOutput recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience) {
        ModRecipeProvider.foodSmelting(recipeOutput, material, result, experience, 200);
        ModRecipeProvider.foodSmoking(recipeOutput, material, result, experience, 100);
        ModRecipeProvider.foodCampfireCooking(recipeOutput, material, result, experience, 600);
    }

    protected static void foodSmelting(@NotNull RecipeOutput recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience, int cookingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, (RecipeSerializer)RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new).unlockedBy(ModRecipeProvider.getHasName((ItemLike)material), ModRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    protected static void foodSmoking(@NotNull RecipeOutput recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience, int cookingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, (RecipeSerializer)RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new).unlockedBy(ModRecipeProvider.getHasName((ItemLike)material), ModRecipeProvider.has((ItemLike)material)).save(recipeOutput, "rusticdelight:" + ModRecipeProvider.getItemName((ItemLike)result) + "_from_smoking");
    }

    protected static void foodCampfireCooking(@NotNull RecipeOutput recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience, int cookingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, (RecipeSerializer)RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new).unlockedBy(ModRecipeProvider.getHasName((ItemLike)material), ModRecipeProvider.has((ItemLike)material)).save(recipeOutput, "rusticdelight:" + ModRecipeProvider.getItemName((ItemLike)result) + "_from_campfire_cooking");
    }

    protected static void simpleSushiRoll(@NotNull RecipeOutput recipeOutput, @NotNull ItemLike ingredient, @NotNull ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (int)2).requires(ingredient).requires(ingredient).requires((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).save(recipeOutput);
    }

    protected static void pancakeRecipes(@NotNull RecipeOutput recipeOutput, @NotNull DeferredItem<Item> pancakeBlock, @NotNull DeferredItem<Item> singlePancake, Ingredient topping, Ingredient ingredient) {
        ModRecipeProvider.pancakeRecipes(recipeOutput, pancakeBlock, singlePancake, topping, ingredient, ingredient);
    }

    protected static void pancakeRecipes(@NotNull RecipeOutput recipeOutput, @NotNull DeferredItem<Item> pancakeBlock, @NotNull DeferredItem<Item> singlePancake, Ingredient topping, Ingredient ingredient, Ingredient ingredient2) {
        DeferredItem<Item> batter = ModItems.BATTER;
        Item servingItem = Items.BOWL;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, pancakeBlock, (int)1).pattern(" T ").pattern("XMX").pattern("YBY").define(Character.valueOf('T'), topping).define(Character.valueOf('X'), ingredient).define(Character.valueOf('Y'), ingredient2).define(Character.valueOf('M'), batter).define(Character.valueOf('B'), (ItemLike)servingItem).unlockedBy(ModRecipeProvider.getHasName(batter), ModRecipeProvider.has(batter)).save(recipeOutput);
        CookingPotRecipeBuilder.cookingPotRecipe(pancakeBlock, (int)1, (int)400, (float)2.0f, (ItemLike)servingItem).addIngredient(batter).addIngredient(topping).addIngredient(ingredient, 2).addIngredient(ingredient2, 2).unlockedByAnyIngredient(new ItemLike[]{batter}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(recipeOutput, pancakeBlock.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pancakeBlock}), (Ingredient)Ingredient.of(CommonTags.TOOLS_KNIFE), singlePancake, (int)PancakeBlock.MAX_SERVINGS).addResult((ItemLike)servingItem).build(recipeOutput, pancakeBlock.getId());
        ModRecipeProvider.oneToOne(recipeOutput, RecipeCategory.MISC, pancakeBlock, (ItemLike)singlePancake.get(), PancakeBlock.MAX_SERVINGS);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, pancakeBlock).requires(singlePancake, PancakeBlock.MAX_SERVINGS.intValue()).requires((ItemLike)servingItem).unlockedBy(ModRecipeProvider.getHasName(singlePancake), ModRecipeProvider.has(singlePancake)).save(recipeOutput, ModRecipeProvider.getRecipeName(singlePancake, pancakeBlock));
    }

    protected static void pieRecipes(@NotNull RecipeOutput recipeOutput, @NotNull DeferredItem<Item> pieBlock, @NotNull DeferredItem<Item> sliceItem, Ingredient topping) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, pieBlock, (int)1).pattern("TTT").pattern("MMM").pattern("SCS").define(Character.valueOf('T'), topping).define(Character.valueOf('M'), CommonTags.FOODS_MILK).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get())), ModRecipeProvider.has((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, pieBlock, (int)1).pattern("##").pattern("##").define(Character.valueOf('#'), sliceItem).unlockedBy(ModRecipeProvider.getHasName(sliceItem), ModRecipeProvider.has(sliceItem)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"rusticdelight", (String)(ModRecipeProvider.getItemName(pieBlock) + "_from_slices")));
    }

    protected static String getRecipeName(ItemLike item, ItemLike result) {
        return "rusticdelight:" + ModRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)item);
    }

    private static Ingredient vegetablesPatch() {
        return DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
    }
}

