/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.ingredient;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class EffectInstanceStack
extends EmiStack {
    private static final EffectRenderer RENDERER = new EffectRenderer(false){};
    private final MobEffectInstance effect;

    public EffectInstanceStack(MobEffectInstance effect) {
        this.effect = effect;
    }

    public EffectInstanceStack(MobEffect effect, long duration) {
        this((Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), (int)duration);
    }

    public EffectInstanceStack(Holder<MobEffect> effect, int duration) {
        this(new MobEffectInstance(effect, duration));
    }

    public EffectInstanceStack(Holder<MobEffect> effect) {
        this(effect, 30);
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    public EmiStack copy() {
        return new EffectInstanceStack(new MobEffectInstance(this.effect.getEffect(), this.effect.getDuration(), this.effect.getAmplifier(), this.effect.isAmbient(), this.effect.isVisible(), this.effect.showIcon(), this.effect.hiddenEffect));
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        RENDERER.render(draw, this.effect, x - 1, y - 1, 16, 16);
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.effect.getEffect();
    }

    public ResourceLocation getId() {
        return ((ResourceKey)this.effect.getEffect().unwrapKey().get()).location();
    }

    public List<Component> getTooltipText() {
        Minecraft client = Minecraft.getInstance();
        return EffectRenderer.getTooltipsWithDescription(this.effect, (TooltipFlag)(client.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL), false, false);
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::create).toList());
        ResourceLocation id = this.getId();
        if (EmiConfig.appendModId && id != null) {
            String mod = EmiUtil.getModName((String)id.getNamespace());
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)mod, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
        }
        list.addAll(super.getTooltip());
        return list;
    }

    public Component getName() {
        return ((MobEffect)this.effect.getEffect().value()).getDisplayName();
    }

    public ItemStack getItemStack() {
        ItemStack item = new ItemStack((ItemLike)Items.POTION);
        PotionContents potionContents = new PotionContents(Optional.empty(), Optional.of(((MobEffect)this.effect.getEffect().value()).getColor()), Collections.singletonList(this.normalize()));
        item.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        return item;
    }

    public MobEffectInstance normalize() {
        return new MobEffectInstance(this.effect.getEffect(), 600, 0, this.effect.isAmbient(), this.effect.isVisible(), this.effect.showIcon(), this.effect.hiddenEffect);
    }
}

