/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.Config;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.Registration;
import com.tom.createores.components.OreVeinAtlasDataComponent;
import com.tom.createores.network.NetworkHandler;
import com.tom.createores.network.OreVeinInfoPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ComponentJoiner;
import com.tom.createores.util.RandomSpreadGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class OreVeinFinderItem
extends Item {
    public OreVeinFinderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (!level.isClientSide) {
            this.detect(level, player.blockPosition(), player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (!ctx.getLevel().isClientSide) {
            this.detect(ctx.getLevel(), ctx.getClickedPos(), ctx.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext p_339594_, List<Component> pTooltipComponents, TooltipFlag p_41424_) {
        if (pStack.get(CreateOreExcavation.ORE_VEIN_FINDER_FILTERED_COMPONENT) == Boolean.TRUE) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.coe.vein_finder.filtered"));
        }
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.isClientSide && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pLevel.getGameTime() % 20L == 10L) {
                boolean hasAtlas = false;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack is = player.getInventory().getItem(i);
                    if (is.getItem() != Registration.VEIN_ATLAS_ITEM.get()) continue;
                    hasAtlas = true;
                    break;
                }
                pStack.set(CreateOreExcavation.ORE_VEIN_FINDER_FILTERED_COMPONENT, (Object)hasAtlas);
            }
        }
    }

    public boolean isFoil(ItemStack pStack) {
        return pStack.get(CreateOreExcavation.ORE_VEIN_FINDER_FILTERED_COMPONENT) == Boolean.TRUE || super.isFoil(pStack);
    }

    private void detect(Level level, BlockPos pos, Player player) {
        OreVeinAtlasDataComponent atlasData;
        ItemStack atlas = ItemStack.EMPTY;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack is = player.getInventory().getItem(i);
            if (is.getItem() != Registration.VEIN_ATLAS_ITEM.get()) continue;
            atlas = is;
            break;
        }
        Predicate<RecipeHolder<VeinRecipe>> filter = (atlasData = (OreVeinAtlasDataComponent)atlas.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT)) != null ? this.makeFilter(atlasData) : a -> true;
        ChunkPos center = new ChunkPos(pos);
        OreData found = null;
        ArrayList<OreData> nearby = new ArrayList<OreData>();
        int near = Config.veinFinderNear;
        for (int x = -near; x <= near; ++x) {
            for (int z = -near; z <= near; ++z) {
                OreData d2 = OreDataAttachment.getData(level.getChunk(center.x + x, center.z + z));
                if (x == 0 && z == 0) {
                    found = d2;
                    continue;
                }
                nearby.add(d2);
            }
        }
        player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.info"), false);
        player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.pos", (Object[])new Object[]{center.x, center.z}), false);
        RecipeManager m = level.getRecipeManager();
        MutableComponent nothing = Component.translatable((String)"chat.coe.veinFinder.nothing");
        MutableComponent comma = Component.literal((String)", ");
        Object f = found != null && found.getRecipe(m) != null ? ((VeinRecipe)found.getRecipe(m).value()).getName() : nothing;
        player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.found", (Object[])new Object[]{f}), false);
        CompoundTag infoTag = new CompoundTag();
        ResourceLocation id = found.getRecipeId();
        if (id != null) {
            infoTag.putString("found", id.toString());
        }
        infoTag.putInt("x", pos.getX());
        infoTag.putInt("z", pos.getZ());
        ResourceLocation rl = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(RecipeHolder::id).findFirst().orElse(null);
        if (rl != null) {
            infoTag.putString("nearby", rl.toString());
        }
        f = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(r -> ((VeinRecipe)r.value()).getName()).collect(ComponentJoiner.joining((Component)nothing, (Component)comma));
        player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.nearby", (Object[])new Object[]{f}), false);
        Pair<BlockPos, RecipeHolder<VeinRecipe>> nearest = OreVeinGenerator.getPicker((ServerLevel)level).locate(pos, (ServerLevel)level, 16, filter);
        if (nearest != null) {
            BlockPos at = (BlockPos)nearest.getFirst();
            int i = Math.round(RandomSpreadGenerator.distance2d(at, pos) / (float)Config.veinFinderFar) * Config.veinFinderFar;
            player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.far", (Object[])new Object[]{Component.translatable((String)"chat.coe.veinFinder.distance", (Object[])new Object[]{((VeinRecipe)((RecipeHolder)nearest.getSecond()).value()).getName(), i})}), false);
            infoTag.putString("far", ((RecipeHolder)nearest.getSecond()).id().toString());
            infoTag.putInt("dist", i);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.far", (Object[])new Object[]{nothing}), false);
        }
        NetworkHandler.sendTo((ServerPlayer)player, new OreVeinInfoPacket(infoTag));
        player.getCooldowns().addCooldown((Item)this, Config.veinFinderCd);
    }

    private Predicate<RecipeHolder<VeinRecipe>> makeFilter(OreVeinAtlasDataComponent atlasTag) {
        if (atlasTag.target().isPresent()) {
            ResourceLocation t = atlasTag.target().get();
            return v -> t.equals((Object)v.id());
        }
        HashSet<ResourceLocation> exclude = new HashSet<ResourceLocation>(atlasTag.exclude());
        if (exclude.isEmpty()) {
            return a -> true;
        }
        return v -> !exclude.contains(v.id());
    }
}

