/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;

public class UpgradeLayer
extends GeoRenderLayer<ReplacedSnowGolem> {
    private final ReplacedSnowGolemRenderer renderer;

    public UpgradeLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void render(PoseStack poseStack, ReplacedSnowGolem animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        SnowGolem entity = (SnowGolem)this.renderer.getCurrentEntity();
        if (entity.isInvisible()) {
            return;
        }
        if (entity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)entity;
            ItemStack scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF);
            UpgradeLayer.getTexture(scarf).ifPresent(texture -> {
                RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
                VertexConsumer consumer = bufferSource.getBuffer(translucentType);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, translucentType, consumer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
            });
            ItemStack face = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            UpgradeLayer.getTexture(face).ifPresent(texture -> {
                RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
                VertexConsumer consumer = bufferSource.getBuffer(translucentType);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, translucentType, consumer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
            });
            ItemStack hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT);
            UpgradeLayer.getTexture(hat).ifPresent(texture -> {
                RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
                VertexConsumer consumer = bufferSource.getBuffer(translucentType);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, translucentType, consumer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
            });
        }
    }

    private static Optional<ResourceLocation> getTexture(ItemStack item) {
        if (item.isEmpty()) {
            return Optional.empty();
        }
        ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        if (itemPath == null) {
            return Optional.empty();
        }
        return Optional.of(WinterOverhaul.id("textures/entity/upgrades/" + itemPath.getPath() + ".png"));
    }
}

