/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;

public class PopupCustomColor
extends GuiPopupCore<GuiTabEditAbstract> {
    public FluxEditBox mColor;
    public SimpleButton mCancel;
    public SimpleButton mApply;
    public int mCurrentColor;

    public PopupCustomColor(GuiTabEditAbstract host, int currentColor) {
        super(host);
        this.mCurrentColor = currentColor;
    }

    @Override
    public void init() {
        super.init();
        this.mCancel = new SimpleButton(this, this.leftPos + this.imageWidth / 2 + 12, this.topPos + 86, 48, 12, FluxTranslate.CANCEL.get());
        this.mButtons.add(this.mCancel);
        this.mApply = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 12 - 48, this.topPos + 86, 48, 12, FluxTranslate.APPLY.get());
        this.mButtons.add(this.mApply);
        this.mColor = FluxEditBox.create("0x", this.font, this.leftPos + this.imageWidth / 2 - 40, this.topPos + 64, 80, 12).setHexOnly();
        this.mColor.setMaxLength(6);
        this.mColor.setValue(Integer.toHexString(this.mCurrentColor).toUpperCase(Locale.ROOT));
        this.mColor.setResponder(string -> this.mApply.setClickable(string.length() == 6));
        this.addRenderableWidget((GuiEventListener)this.mColor);
    }

    @Override
    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        gr.drawCenteredString(this.font, FluxTranslate.CUSTOM_COLOR.get(), this.leftPos + 88, this.topPos + 48, 0xFFFFFF);
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button == this.mCancel) {
                ((GuiTabEditAbstract)this.mHost).closePopup();
            } else if (button == this.mApply) {
                this.mCurrentColor = this.mColor.getIntegerFromHex();
                ((GuiTabEditAbstract)this.mHost).closePopup();
            }
        }
    }
}

