/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.register.DataAttachments;

@ParametersAreNonnullByDefault
public class FluxUtils {
    private static final double[] COMPACT_SCALE = new double[]{0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18};
    public static final Direction[] DIRECTIONS = Direction.values();

    private FluxUtils() {
    }

    @Nonnull
    public static <E extends Enum<E>> E cycle(@Nonnull E val, @Nonnull E[] values) {
        int next = val.ordinal() + 1;
        if (next < values.length) {
            return values[next];
        }
        return values[0];
    }

    @Nullable
    public static Direction getBlockDirection(@Nonnull BlockPos base, @Nonnull BlockPos target) {
        if (base.equals((Object)target)) {
            return null;
        }
        BlockPos.MutableBlockPos test = new BlockPos.MutableBlockPos();
        for (Direction dir : DIRECTIONS) {
            test.set((Vec3i)base);
            if (!test.move(dir).equals((Object)target)) continue;
            return dir;
        }
        return null;
    }

    @Nonnull
    public static String getTransferInfo(@Nonnull IFluxDevice flux, EnergyType energyType) {
        FluxDeviceType type = flux.getDeviceType();
        long change = flux.getTransferChange();
        if (type.isPlug()) {
            if (change == 0L) {
                return FluxTranslate.INPUT.get() + ": " + String.valueOf(ChatFormatting.GOLD) + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.INPUT.get() + ": " + String.valueOf(ChatFormatting.GREEN) + "+" + energyType.getUsage(change);
        }
        if (type.isPoint() || type.isController()) {
            if (change == 0L) {
                return FluxTranslate.OUTPUT.get() + ": " + String.valueOf(ChatFormatting.GOLD) + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.OUTPUT.get() + ": " + String.valueOf(ChatFormatting.RED) + energyType.getUsage(change);
        }
        if (type.isStorage()) {
            if (change == 0L) {
                return FluxTranslate.CHANGE.get() + ": " + String.valueOf(ChatFormatting.GOLD) + "0 " + energyType.getUsageSuffix();
            }
            if (change > 0L) {
                return FluxTranslate.CHANGE.get() + ": " + String.valueOf(ChatFormatting.GREEN) + "+" + energyType.getUsage(change);
            }
            return FluxTranslate.CHANGE.get() + ": " + String.valueOf(ChatFormatting.RED) + energyType.getUsage(change);
        }
        return "";
    }

    public static void writeGlobalPos(@Nonnull CompoundTag tag, @Nonnull GlobalPos pos) {
        BlockPos p = pos.pos();
        tag.putInt("x", p.getX());
        tag.putInt("y", p.getY());
        tag.putInt("z", p.getZ());
        tag.putString("dim", pos.dimension().location().toString());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull CompoundTag tag) {
        return GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("dim"))), (BlockPos)new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z")));
    }

    public static void writeGlobalPos(@Nonnull FriendlyByteBuf buffer, @Nonnull GlobalPos pos) {
        buffer.writeResourceLocation(pos.dimension().location());
        buffer.writeBlockPos(pos.pos());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull FriendlyByteBuf buffer) {
        return GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation()), (BlockPos)buffer.readBlockPos());
    }

    @Nonnull
    public static String getDisplayPos(@Nonnull GlobalPos pos) {
        BlockPos p = pos.pos();
        return "X: " + p.getX() + " Y: " + p.getY() + " Z: " + p.getZ();
    }

    @Nonnull
    public static String getDisplayDim(@Nonnull GlobalPos pos) {
        return pos.dimension().location().toString();
    }

    public static <T> boolean addWithCheck(@Nonnull Collection<T> list, @Nullable T toAdd) {
        if (toAdd != null && !list.contains(toAdd)) {
            list.add(toAdd);
            return true;
        }
        return false;
    }

    public static int getModifiedColor(int color, float factor) {
        float h;
        int min;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int delta = max - (min = Math.min(r, Math.min(g, b)));
        if (delta == 0) {
            return Mth.hsvToRgb((float)0.0f, (float)0.0f, (float)Math.min(factor * (float)max / 255.0f, 1.0f));
        }
        if (max == r) {
            h = (float)(g - b) / (float)delta;
            if (h < 0.0f) {
                h += 6.0f;
            }
        } else {
            h = max == g ? 2.0f + (float)(b - r) / (float)delta : 4.0f + (float)(r - g) / (float)delta;
        }
        return Mth.hsvToRgb((float)(h / 6.0f), (float)Math.min(factor * (float)delta / (float)max, 1.0f), (float)Math.min(factor * (float)max / 255.0f, 1.0f));
    }

    public static String compact(long in) {
        if (in < 1000L) {
            return Long.toString(in);
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f%c", (double)in * COMPACT_SCALE[level], Character.valueOf(pre));
    }

    public static String compact(long in, String suffix) {
        if (in < 1000L) {
            return in + " " + suffix;
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f %c%s", (double)in * COMPACT_SCALE[level], Character.valueOf(pre), suffix);
    }

    public static boolean isBadNetworkName(@Nonnull String s) {
        return s.isEmpty() || s.length() > 24;
    }

    public static boolean isBadPassword(@Nonnull String s) {
        if (s.isEmpty() || s.length() > 16) {
            return true;
        }
        int e = s.length();
        for (int i = 0; i < e; ++i) {
            if (!FluxUtils.isBadPasswordChar(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadPasswordChar(char c) {
        return c >= '\u007f' || c <= ' ';
    }

    @Nonnull
    public static FluxPlayerData getPlayerData(ServerPlayer player) {
        return (FluxPlayerData)player.getData(DataAttachments.PLAYER_DATA);
    }

    @Nullable
    public static <T> T get(@Nonnull BlockEntity target, @Nonnull BlockCapability<T, Direction> cap, Direction side) {
        return (T)cap.getCapability(target.getLevel(), target.getBlockPos(), target.getBlockState(), target, (Object)side);
    }

    @Nullable
    public static <T> T get(@Nonnull ItemStack stack, ItemCapability<T, Void> cap) {
        return (T)stack.getCapability(cap);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }
}

