/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class DetectorModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "detector.mode");
    private static final List<MutableComponent> SUBTEXT_EQUAL = List.of(IdentifierUtil.createTranslation("gui", "detector.mode.equal").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_ABOVE = List.of(IdentifierUtil.createTranslation("gui", "detector.mode.above").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_UNDER = List.of(IdentifierUtil.createTranslation("gui", "detector.mode.under").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation EQUAL = IdentifierUtil.createIdentifier("widget/side_button/detector_mode/equal");
    private static final ResourceLocation ABOVE = IdentifierUtil.createIdentifier("widget/side_button/detector_mode/above");
    private static final ResourceLocation UNDER = IdentifierUtil.createIdentifier("widget/side_button/detector_mode/under");
    private final ClientProperty<DetectorMode> property;

    DetectorModeSideButtonWidget(ClientProperty<DetectorMode> property) {
        super(DetectorModeSideButtonWidget.createPressAction(property));
        this.property = property;
    }

    private static Button.OnPress createPressAction(ClientProperty<DetectorMode> property) {
        return btn -> property.setValue(DetectorModeSideButtonWidget.toggle((DetectorMode)((Object)((Object)property.getValue()))));
    }

    private static DetectorMode toggle(DetectorMode detectorMode) {
        return switch (detectorMode) {
            default -> throw new MatchException(null, null);
            case DetectorMode.UNDER -> DetectorMode.EQUAL;
            case DetectorMode.EQUAL -> DetectorMode.ABOVE;
            case DetectorMode.ABOVE -> DetectorMode.UNDER;
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case DetectorMode.UNDER -> UNDER;
            case DetectorMode.EQUAL -> EQUAL;
            case DetectorMode.ABOVE -> ABOVE;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case DetectorMode.UNDER -> SUBTEXT_UNDER;
            case DetectorMode.EQUAL -> SUBTEXT_EQUAL;
            case DetectorMode.ABOVE -> SUBTEXT_ABOVE;
        };
    }
}

